% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook.R
\name{codebook}
\alias{codebook}
\title{Codebook: Detailed information about variables}
\usage{
codebook(data)
}
\arguments{
\item{data}{dataframe}
}
\value{
Codebook in data.frame format
}
\description{
\code{codebook()} provides detailed information about each variable
within the dataset.
}
\details{
\code{codebook} generates the report of data structure with names,
data lables, types,
number of observations, number of observations with missing values and
percentage of observations with missing values.

\strong{ANNOTATIONS}:

Variable - Names of variables

Label     - Labels of variables

Type     - Types of variables

_Obs - Counts of valid observations

_NA  - Counts of observations with missing value

_NA(\%)    - Percentage of observations with missing value
}
\examples{

## use infert data
data(infert)
codebook(infert)

## add labels
infert.new <- labelVar(infert,
                       c(education, age, parity, induced, case, spontaneous,
                         stratum, pooled.stratum),
                       c("Education", "Age in years of case", "Count",
                         "# of prior induced abortions", "case status",
                         "# of prior spon. abortions",
                         "Matched set number", "Stratum Number"))
infert.new <- labelData(infert.new,
                        "Infertility after Spontaneous and Induced Abortion")
codebook(infert.new)


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
