% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-po-model.r
\name{weib.gpo}
\alias{weib.gpo}
\title{Generalized PO model with Weibull baseline}
\usage{
weib.gpo(
  formula,
  data,
  g,
  scale,
  shape,
  eta = 1,
  eta.known = TRUE,
  controls = mable.ctrl(),
  progress = TRUE
)
}
\arguments{
\item{formula}{regression formula. Response must be \code{cbind}. See 'Details'.}

\item{data}{a dataset}

\item{g}{initial \eqn{d}-vector of regression coefficients}

\item{scale}{initial guess of the scale parameter for Weibull baseline}

\item{shape}{initial guess of the shape parameter for Weibull baseline}

\item{eta}{the given positive value of \eqn{\eta}. See 'Details'.}

\item{eta.known}{logical. If \code{TRUE} \code{eta} is the known values of \eqn{\eta},
else \code{eta} is an initial guess of \eqn{\eta}. See 'Details'.}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and other control options. Default is \code{\link{mable.ctrl}}.}

\item{progress}{if \code{TRUE} a text progressbar is displayed}
}
\value{
a class '\code{mable_reg}' object, a list with components
\itemize{
\item \code{convergence} an integer code, 0 indicates successful 
   completion(the iteration is convergent), 1 indicates that 
  the maximum iteration had been reached in the calculation;
\item \code{delta} the final convergence criterion for Newton iteration;
}
}
\description{
Maximum likelihood estimation in generalized proportional odds 
 rate regression model with Weibull baseline based on interal
 censored event time data
}
\details{
???
}
\examples{
\donttest{
## Simulated Weibull data
require(icenReg)
set.seed(111)
simdata<-simIC_weib(100, model = "po", inspections = 2, 
   inspectLength = 2.5, prob_cen=1)
sp<-ic_sp(cbind(l, u) ~ x1 + x2, data = simdata, model="po") 
gt<--sp$coefficients
res0<-maple.po(cbind(l, u) ~ x1 + x2, data = simdata, M=c(1,20), g=gt, tau=6)
op<-par(mfrow=c(1,2))
plot(res0,  which=c("likelihood","change-point"))
par(op)
res1<-mable.po(cbind(l, u) ~ x1 + x2, data = simdata, M=c(1,20), g=gt, 
   tau=6, x0=data.frame(x1=max(simdata$x1),x2=-1))
res2<-weib.gpo(cbind(l, u) ~ x1 + x2, data = simdata, g=gt, scale=2, shape=2)  
op<-par(mfrow=c(2,2))    
plot(res1,  which=c("likelihood","change-point")) 
plot(res0, y=data.frame(x1=0,x2=0), which="density", add=FALSE, type="l",
    xlab="Time", main="Desnity Function")
plot(res1, y=data.frame(x1=0,x2=0), which="density", add=TRUE, lty=2, col=4)
lines(xx<-seq(0, 7, len=512), dweibull(xx, 2,2), lty=3, col=2, lwd=1.5)
lines(xx, dweibull(xx, res2$shape, res2$scale), lty=5, col=5, lwd=1.5)
legend("topright", bty="n", lty=1:3, col=c(1,4,2), c(expression(hat(f)[0]),
    expression(tilde(f)[0]), expression(f[0])))
plot(res0, y=data.frame(x1=0,x2=0), which="survival", add=FALSE, type="l",
    xlab="Time", main="Survival Function")
plot(res1, y=data.frame(x1=0,x2=0), which="survival", add=TRUE, lty=2, col=4)
lines(xx, 1-pweibull(xx, 2, 2), lty=2, col=2)
lines(xx, 1-pweibull(xx, res2$shape, res2$scale), lty=5, col=5, lwd=1.5)
legend("topright", bty="n", lty=1:3, col=c(1,4,2), c(expression(hat(S)[0]),
    expression(tilde(S)[0]), expression(S[0])))
par(op)
}
}
