% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSource.R
\name{readSource}
\alias{readSource}
\title{readSource}
\usage{
readSource(
  type,
  subtype = NULL,
  subset = NULL,
  convert = TRUE,
  supplementary = FALSE
)
}
\arguments{
\item{type}{A character string referring to the source type, e.g. "IEA" which would
internally call a function called `readIEA` (the "wrapped function"). A list of
available source types can be retrieved with function \code{\link{getSources}}.}

\item{subtype}{A character string. For some sources there are subtypes of the source, for these
sources the subtype can be specified with this argument. If a source does not
have subtypes, subtypes should not be set.}

\item{subset}{A character string. Similar to \code{subtype} a source can also have \code{subsets}.
A \code{subsets} can be used to only read part of the data. This can in particular make sense
for huge data sets where reading in the whole data set might be impractical or even infeasible.}

\item{convert}{Boolean indicating whether input data conversion to
ISO countries should be done or not. In addition it can be set to "onlycorrect"
for sources with a separate correctXXX-function.}

\item{supplementary}{Boolean deciding whether a list including the actual data and metadata,
or just the actual data is returned.}
}
\value{
The read-in data, usually a magpie object. If supplementary is TRUE a list including
the data and metadata is returned instead. The temporal and data dimensionality
should match the source data. The spatial dimension should either match the source data or,
if the convert argument is set to TRUE, should be on ISO code country level.
}
\description{
Read in a source file and convert it to a MAgPIE object. The function is a
wrapper for specific functions designed for the different possible source
types.
}
\note{
If a magpie object is returned magclass::clean_magpie is run and if convert = TRUE
ISO code country level is checked.
}
\examples{
\dontrun{
a <- readSource("Tau", "paper")
}

}
\seealso{
\code{\link{setConfig}}, \code{\link{downloadSource}}, \code{\link{readTau}}
#' @note The underlying read-functions can return a magpie object or a list of information
(preferred) back to \code{readSource}. In list format the object should have the following
structure:
\itemize{
\item \bold{x} - the data itself as magclass object
\item \bold{unit} (optional) - unit of the provided data
\item \bold{description} (otional) - a short description of the data
\item \bold{note} (optional) - additional notes related to the data
\item \bold{class} (optional | default = "magpie") - Class of the returned object. If set to
something other than "magpie" most functionality will not be available and is switched off!
\item \bold{cache} (optional) boolean which decides whether a cache file should be written (if caching is active)
or not. Default setting is TRUE. This can be for instance useful, if the calculation itself is quick, but
the corresponding file sizes are huge. Or if the caching for the given data type does not support storage
in RDS format. CAUTION: Deactivating caching for a data set which should be part of a PUC file
will corrupt the PUC file. Use with care.
}
}
\author{
Jan Philipp Dietrich, Anastasis Giannousakis, Lavinia Baumstark, Pascal Führlich
}
