% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolManualDownload.R
\name{toolManualDownload}
\alias{toolManualDownload}
\title{Tool: ManualDownload}
\usage{
toolManualDownload(
  instructions,
  intro = "Data must be downloaded manually",
  request = "Enter full path to the downloaded data:"
)
}
\arguments{
\item{instructions}{Download instructions in form of a character vector describing how to manually
retrieve the data.}

\item{intro}{Introductory sentence to be shown first. Will not show up if set to NULL.}

\item{request}{A prompt which should show up after the instructions to ask for the local download location.}
}
\description{
Support tool for the creation of download functions in cases where a fully automated data download is not
an option (e.g. due to a missing API). The function can be used to print a step-by-step guide for the user
how to manually retrieve the data and then asks for a (local) path where the data can be copied from.
}
\examples{
\dontrun{
toolManualDownload(c("Log into website ABC",
                     "Download the data set XYZ"))
}
}
\seealso{
\code{\link{downloadSource}}
}
\author{
Jan Philipp Dietrich
}
