% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_pivot_wider}
\alias{data_dict_pivot_wider}
\title{Transform column(s) of a data dictionary from long format to wide format}
\usage{
data_dict_pivot_wider(data_dict, taxonomy = NULL)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed.}

\item{taxonomy}{A tibble identifying the scheme used for variables
classification.}
}
\value{
A list of tibble(s) identifying a data dictionary.
}
\description{
Transforms column(s) of a data dictionary from long format to wide format.
If a taxonomy is provided, the corresponding columns in the data
dictionary will be converted to a format with the taxonomy expanded.
This operation is equivalent to performing a 'tidyr::pivot_wider()' on these
columns following the taxonomy structure provided. Variable names in the
data dictionary must be unique.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A taxonomy is classification scheme that can be defined for variable
attributes. If defined, a taxonomy must be a data frame-like object. It must
be compatible with (and is generally extracted from) an Opal environment. To
work with certain functions, a valid taxonomy must contain at least the
columns 'taxonomy', 'vocabulary', and 'terms'. In addition, the taxonomy
may follow Maelstrom research taxonomy, and its content can be evaluated
accordingly, such as naming convention restriction, tagging elements,
or scales, which are specific to Maelstrom Research. In this particular
case, the tibble must also contain 'vocabulary_short', 'taxonomy_scale',
'vocabulary_scale' and 'term_scale' to work with some specific functions.
}
\examples{
{

# use DEMO_files provided by the package

taxonomy <- DEMO_files$taxonomy_opal_mlstr
data_dict <- DEMO_files$dd_TOKYO_format_maelstrom_tagged
data_dict_pivot_wider(data_dict, taxonomy)

}

}
\seealso{
\code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}, \code{\link[=as_data_dict]{as_data_dict()}}
}
