% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-catalogue_functions.R
\name{valueType_adjust}
\alias{valueType_adjust}
\title{Attribute the valueType from a data dictionary to a dataset, or vice versa}
\usage{
valueType_adjust(from, to = NULL)
}
\arguments{
\item{from}{Object to be adjusted. Can be either a dataset or a data
dictionary.}

\item{to}{Object to be adjusted. Can be either a dataset or a data
dictionary. NULL by default.}
}
\value{
Either a tibble, identifying the dataset, or a list of tibble(s)
identifying a data dictionary, depending which is 'to'.
}
\description{
Takes the valueType of the input (from) and attributes it to the output (to).
The parameters 'from' and 'to' can be either a dataset or a data dictionary.
Depending on the input provided, the valueType replaced is either in the
'valueType' column of a data dictionary or cast to a column in a dataset.
If 'to' is not provided, the function calls \code{\link[=valueType_self_adjust]{valueType_self_adjust()}}
instead. The possible values returned are 'date', 'boolean', 'integer',
'decimal', and text'.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

# use DEMO_files provided by the package
library(dplyr)

dataset <- DEMO_files$dataset_TOKYO[c(1:4),'prg_ever']
data_dict <-
  DEMO_files$dd_TOKYO_format_maelstrom_tagged \%>\%
  data_dict_filter(filter_var = 'name == "prg_ever"') \%>\%
  as_data_dict_mlstr()
valueType_adjust(from = dataset,to = data_dict)

}

}
\seealso{
\code{\link[=valueType_self_adjust]{valueType_self_adjust()}}
}
