% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_data_dict_categories}
\alias{check_data_dict_categories}
\title{Assess a data dictionary for potential issues in categories}
\usage{
check_data_dict_categories(data_dict)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be evaluated.}
}
\value{
A data frame providing categorical variables that has issues within a
data dictionary.
}
\description{
Generates a data frame report of any categorical variable name present in the
'Categories' element but not present in 'Variables'. The data frame also
reports any non-unique combinations of 'variable' and 'name' in the
'Categories' element.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package

data_dict <- madshapR_DEMO$`data_dict_TOKYO - errors`
check_data_dict_categories(data_dict)

}

}
