% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-data_visualize.R
\name{variable_visualize}
\alias{variable_visualize}
\title{Generate a list of charts, figures and summary tables of a variable}
\usage{
variable_visualize(
  dataset = tibble(id = as.character()),
  col,
  data_dict = NULL,
  group_by = NULL,
  valueType_guess = FALSE,
  variable_summary = .summary_var,
  .summary_var = NULL
)
}
\arguments{
\item{dataset}{A dataset object.}

\item{col}{A character string specifying the name of the column.}

\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset. Automatically generated if not provided.}

\item{group_by}{A character string identifying the column in the dataset
to use as a grouping variable. Elements will be grouped by this
column.}

\item{valueType_guess}{Whether the output should include a more accurate
valueType that could be applied to the dataset. FALSE by default.}

\item{variable_summary}{A summary list which is the summary of the variables.}

\item{.summary_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A list of up to seven elements (charts and figures and datatables) which can
be used to summarize visualize data.
}
\description{
Analyses the content of a variable and its data dictionary (if any),
identifies its data type and values accordingly and generates figures and
summaries (datatable format). The figures and tables are representations of
data distribution, statistics and valid/non valid/missing values (based on
the data dictionary information if provided and the data type of the
variable). This function can be used to personalize report parameters and is
internally used in the function \code{\link[=dataset_visualize]{dataset_visualize()}}. Up to seven objects
are generated which include : One datatable of the key elements of the
data dictionary, one datatable summarizing statistics (such as mean,
quartile, most seen value, most recent date, ... , depending on the
data type of the variable), two graphs showing the distribution of the
variable, One bar chart for categorical values (if any), One bar chart for
missing values (if any), One pie chart for the proportion of valid and
missing values (if any). The variable can be grouped using \code{group_by}
parameter, which is a (categorical) column in the dataset. The user may need
to use \code{\link[=as_category]{as_category()}} in this context. To fasten the process (and allow
recycling object in a workflow) the user can feed the function with a
\code{variable_summary}, which is the output of the function \code{\link[=dataset_summarize]{dataset_summarize()}}
of the column(s) \code{col} and  \code{group_by}. The summary must have the same
parameters to operate.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

 library(dplyr)
 library(fs)
 
 dataset <- madshapR_DEMO$dataset_TOKYO
 
 variable_summary <- madshapR_DEMO$`dataset_summary`
  
 variable_visualize(
   dataset, col = 'height',
   variable_summary =  variable_summary)
 
 
}

}
\seealso{
\code{\link[DT:datatable]{DT::datatable()}}, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
\code{\link[=dataset_summarize]{dataset_summarize()}}, \code{\link[=dataset_visualize]{dataset_visualize()}}
}
