% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_collapse}
\alias{data_dict_collapse}
\title{Transform multi-row category column(s) to single rows and join to "Variables"}
\usage{
data_dict_collapse(
  data_dict,
  from = "Categories",
  to = "Variables",
  name_prefix = "Categories::"
)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
transformed.}

\item{from}{A symbol identifying the name of the element (data frame) to take
column(s) from. Default is 'Categories'.}

\item{to}{A symbol identifying the name of the element (data frame) to create
column(s) to. Default is 'Variables'.}

\item{name_prefix}{A character string of the prefix of columns of interest.
This prefix will be used to select columns, and to rename them in the 'to'
element. Default is 'Categories::'.}
}
\value{
A list of data frame(s) identifying a data dictionary.
}
\description{
Collapses a data dictionary element (the parameter 'from'),
into column(s) in another element (the parameter 'to')
If the element 'to' exists, and contains any column 'xx' or 'yy', these
columns will be added to the element 'from' under the names 'to:xx'
and 'to:yy'. (unique names will be generated if necessary). Each element
of these column will gather all information to process the reverse operation.
Separator of each element is the following structure :
'name = xx1 ; name = xx2'.
This function is mainly used to collapse the 'Categories' element into
columns in 'Variables'.
This function is the reversed operation of \code{\link[=data_dict_expand]{data_dict_expand()}}
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_DEMO provided by the package

data_dict <- madshapR_DEMO$data_dict_MELBOURNE
data_dict_collapse(data_dict)

}

}
\seealso{
\code{\link[=data_dict_expand]{data_dict_expand()}}
}
