% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimSums.R
\name{dimSums}
\alias{dimSums}
\title{Summation over dimensions}
\usage{
dimSums(x, dim = 3, na.rm = FALSE)
}
\arguments{
\item{x}{A MAgPIE-object}

\item{dim}{The dimensions(s) to sum over. A vector of dimension codes or dimension names.
See \code{\link{dimCode}} for more information}

\item{na.rm}{logical. Should missing values (including NaN) be omitted from
the calculations?}
}
\value{
A MAgPIE object with values summed over the specified dimensions
}
\description{
This function sums over any (sub-)dimension of a magpie object
}
\examples{
a <- maxample("animal")
dimSums(a, dim = c(1, 2, 3.2))
dimSums(a, dim = c("x", "y", "cell", "month"))
}
\seealso{
\code{\link{rowSums}}, \code{\link{getItems}}, \code{\link{dimCode}}
}
\author{
Jan Philipp Dietrich
}
