% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{transformations}
\alias{transformations}
\alias{image_trim}
\alias{image_background}
\alias{image_crop}
\alias{image_scale}
\alias{image_sample}
\alias{image_border}
\alias{image_noise}
\alias{image_blur}
\alias{image_charcoal}
\alias{image_edge}
\alias{image_oilpaint}
\alias{image_emboss}
\alias{image_enhance}
\alias{image_equalize}
\alias{image_flip}
\alias{image_flop}
\alias{image_frame}
\alias{image_implode}
\alias{image_negate}
\alias{image_normalize}
\alias{image_rotate}
\alias{image_fill}
\alias{image_transparent}
\alias{image_chop}
\alias{image_colorize}
\alias{image_page}
\alias{image_composite}
\alias{image_contrast}
\alias{image_annotate}
\alias{image_convert}
\alias{image_compare}
\alias{image_deskew}
\title{Image Transformations}
\usage{
image_trim(image)

image_background(image, color, flatten = FALSE)

image_crop(image, geometry = "")

image_scale(image, geometry = "")

image_sample(image, geometry = "")

image_border(image, color = "", geometry = "")

image_noise(image, noisetype = "gaussian")

image_blur(image, radius = 1, sigma = 0.5)

image_charcoal(image, radius = 1, sigma = 0.5)

image_edge(image, radius = 1)

image_oilpaint(image, radius = 1)

image_emboss(image, radius = 1, sigma = 0.5)

image_enhance(image)

image_equalize(image)

image_flip(image)

image_flop(image)

image_frame(image, geometry = "25x25+6+6")

image_implode(image, factor = 0.5)

image_negate(image)

image_normalize(image)

image_rotate(image, degrees)

image_fill(image, color, point = "1x1", fuzz = 0)

image_transparent(image, color, fuzz = 0)

image_chop(image, geometry)

image_colorize(image, opacity, color)

image_page(image, pagesize = NULL, density = NULL)

image_composite(image, composite_image = image[1], operator = "atop",
  offset = "0x0")

image_contrast(image, sharpen = 1)

image_annotate(image, text, gravity = "northwest", location = "+0+0",
  degrees = 0, size = 10, font = NULL, color = NULL,
  strokecolor = NULL, boxcolor = NULL)

image_convert(image, format, depth = NULL)

image_compare(image, reference_image, metric = "")

image_deskew(image, treshold = 40)
}
\arguments{
\item{image}{object returned by \code{image_read}}

\item{color}{a valid \href{https://www.imagemagick.org/Magick++/Color.html}{color string}}

\item{flatten}{should image be flattened before writing? This also replaces
transparency with background color.}

\item{geometry}{a string with \href{https://www.imagemagick.org/Magick++/Geometry.html}{geometry syntax}
for example \code{"10x10+5-5"}.}

\item{noisetype}{integer betwee 0 and 5 with
\href{https://www.imagemagick.org/Magick++/Enumerations.html#NoiseType}{noisetype}.}

\item{radius}{the radius of the Gaussian, in pixels, not counting the center pixel.}

\item{sigma}{the standard deviation of the Laplacian, in pixels.}

\item{factor}{image implode factor (special effect)}

\item{degrees}{how many degrees}

\item{point}{string indicating the flood-fill starting point}

\item{fuzz}{Colors within this distance are considered equal.
Use this option to match colors that are close to the target color in RGB space.
I think max distance (from #000000 to #FFFFFF) is 256^3.}

\item{opacity}{percentage of transparency}

\item{pagesize}{geometry string with preferred size and location of an image canvas.}

\item{density}{geometry string with vertical and horizontal resolution in pixels of
the image. Specifies an image density when decoding a Postscript or PDF.}

\item{composite_image}{composition image}

\item{operator}{string with a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{composite operator}.}

\item{offset}{geometry string with offset}

\item{sharpen}{enhance intensity differences in image}

\item{text}{annotation text}

\item{gravity}{string with
\href{https://www.imagemagick.org/Magick++/Enumerations.html#GravityType}{gravity type}}

\item{location}{geometry string with location relative to \code{gravity}}

\item{size}{font-size in pixels}

\item{font}{rendering font. To use a TrueType font, precede the TrueType filename with an @.}

\item{strokecolor}{adds a stroke (border around the text)}

\item{boxcolor}{background color that annotation text is rendered on.}

\item{format}{output format such as \code{png}, \code{jpeg}, \code{gif} or \code{pdf}.
Can also be a bitmap type such as \code{rgba} or \code{rgb}.}

\item{depth}{color depth, must be 8 or 16}

\item{reference_image}{another image to compare to}

\item{metric}{string with a
\href{http://www.imagemagick.org/script/command-line-options.php#metric}{metric type}}

\item{treshold}{straightens an image. A threshold of 40 works for most images.}
}
\description{
Vectorized functions for transforming images. These functions apply
the same transformation to each frame in the image.
The \href{https://www.imagemagick.org/Magick++/STL.html}{Magick++ documentation}
explains meaning of each function and parameter. See \link{editing} for
functions to read or combine image sequences.
}
\details{
Each function returns a copy of the manipulated image; the input image will
be unaffected. Therefore operations can be piped with magrittr if you're
into that kind of stuff.
}
\examples{
logo <- image_read("https://www.r-project.org/logo/Rlogo.png")
logo <- image_scale(logo, "400")
image_trim(logo)
image_background(logo, "pink", flatten = TRUE)
image_crop(logo, "400x400+200+200")
image_scale(logo, "200x200")
image_sample(logo, "200x200")
image_border(logo, "red", "10x10")
image_noise(logo)
image_blur(logo, 10, 10)
image_charcoal(logo)
image_edge(logo)
image_oilpaint(logo)
image_emboss(logo)
image_enhance(logo)
image_equalize(logo)
image_flip(logo)
image_flop(logo)
image_frame(logo)
image_implode(logo)
image_negate(logo)
image_normalize(logo)
image_rotate(logo, 45)
image_fill(image_flatten(logo), "red")
image_fill(image_flatten(logo), "red", fuzz = 25600)
image_chop(logo, "100x20")
image_colorize(logo, 50, "red")
# Compose images using one of many operators
oldlogo <- image_read("https://developer.r-project.org/Logo/Rlogo-3.png")
image_composite(logo, oldlogo)
image_composite(logo, oldlogo, operator = "copyred")

# Lights up the R logo
frames <- image_scale(oldlogo, "400x400")
for(i in 1:7) frames <- c(frames, image_contrast(frames[i]))
(blink <- image_animate(c(frames, rev(frames)), fps = 20, loop = 1))

# Add some text to an image
image_annotate(logo, "This is a test")
image_annotate(logo, "CONFIDENTIAL", size = 50, color = "red", boxcolor = "pink",
 degrees = 30, location = "+100+100")

# Setting fonts requires fontconfig support (and that you have the font)
myfont <- ifelse(identical("windows", .Platform$OS.type), "courier-new", "courier")
try(image_annotate(logo, "The quick brown fox", font = myfont, size = 50))
logo2 <- image_blur(logo)
if(magick_config()$version >= "6.8.7")
 image_compare(logo, logo2, metric = "phash")
}
\seealso{
Other image: \code{\link{editing}}
}
