% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{magmaRset}
\alias{magmaRset}
\title{Set up your magma environment and authentication}
\usage{
magmaRset(
  token = NULL,
  url = "https://magma.ucsf.edu",
  opts = list(followlocation = FALSE)
)
}
\arguments{
\item{token}{Single string. Your personal token from \url{https://janus.ucsf.edu}. 

When not explicitly given, you will be prompted to input it via the console.}

\item{url}{Single string. The url of the production, staging, or development version of magma that you you would like to target.
See \code{\link{authentication-and-environments}} for more information.}

\item{opts}{A named list of curl options and the values to give them (ex: \code{list(followlocation = FALSE, othersetting = 42)}).
Generally, most users can ignore this input, but it can be useful for adjusting proxy settings for particular development environment setup.}
}
\value{
A list with three components: token, url, and opts.
}
\description{
Set up your magma environment and authentication
}
\details{
This function compiles a list, from the given inputs, of the information needed by other \code{magmaR} functions
to properly route and authenticate a call to magma.
}
\examples{

if (interactive()) {
    
    # THE DEFAULT:
    # When run in this way, it will ask you to give your token.
    # And the resulting $url will be the standard, production, magma url.
    prod <- magmaRset()
    print(prod)
         
    # TARGET = staging:
    # Give the proper url.
    # Again, because we are not providing our token to the call, it will ask.
    stage <- magmaRset(url = "https://magma-stage.ucsf.edu")
    print(stage)
    
    # We can also give additional curl options to the 'opts' input:
    prod_opts <- magmaRset(token = prod$token,
        opts = list(proxyport = 1234))
    print(prod_opts)
    
    # Now we can retrieve data with...
    retrieve(
        target = prod,
        projectName = "example",
        modelName = "rna_seq",
        recordNames = "all",
        attributeNames = "all",
        filter = "")
}

}
