% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_well_on_edge.R
\name{is_well_on_edge}
\alias{is_well_on_edge}
\title{Identify the wells on the plate's edge}
\usage{
is_well_on_edge(
  well_number,
  plate_layout = c(96, 384),
  edges = c("top", "bottom", "left", "right"),
  details = FALSE
)
}
\arguments{
\item{well_number}{A vector of positive numeric well identifier}

\item{plate_layout}{An integer indicating the maximum number of well on the plate}

\item{edges}{A character vector pointing which plate edges should be considered}

\item{details}{A logical controlling whether a \link{data.frame} with more details should be returned}
}
\value{
A logical vector, the same length as \code{well_number} indicating whether the well is on the edge. If \code{details = TRUE}, the function returns a \link{data.frame} that complements the logical vector with the \code{well_number}, row and column positions.
}
\description{
Identify the wells on the plate's edge
}
\details{
Flag the wells located on the edges of a 96- or 384-well plate, based on the following well numbering:
\itemize{
\item Well numbers start at 1
\item Well are numbered from left to right and then top to bottom of the plate.
}
}
\examples{
# Logical vector indicating whether the wells are on the four edges
is_well_on_edge(1:96, plate_layout = 96)
# More details can be obtained to verify the results
well_df <- is_well_on_edge(1:96, plate_layout = 96, details = TRUE)
# And the resulting prediction displayed
matrix(well_df$is_edge, ncol = max(well_df$col), byrow = TRUE)
}
