% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{coat}
\alias{coat}
\title{Coat Function}
\usage{
coat(
  x,
  y = NULL,
  pseq = NULL,
  xyz = NULL,
  col.x = gray(0:64/64),
  col.y = NULL,
  breaks.y = NULL,
  zlim.x = NULL,
  zlim.y = NULL,
  rownum = 5,
  colnum = NULL,
  plane = c("axial", "coronal", "sagittal", "all")[1],
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  paron = TRUE,
  cross.hair = FALSE,
  chxy = NULL,
  color.bar = TRUE,
  regionplot = FALSE,
  atlasdataset = NULL,
  regionname = c("atlas", "stat")[1],
  regionlegend = FALSE,
  atlasname = "",
  ROIids = 1:9,
  ...
)
}
\arguments{
\item{x}{image1. Base image.}

\item{y}{image2 to be overcoated.}

\item{pseq}{a vector plot sequence.}

\item{xyz}{a vector position to be plotted.}

\item{col.x}{a color vector for image1.}

\item{col.y}{a color vector for image2.}

\item{breaks.y}{a vector breaks value for y.}

\item{zlim.x}{a vector plot limitation values for z of x.}

\item{zlim.y}{a vector plot limitation values for z of y.}

\item{rownum}{a numeric, the number of row for the plot.}

\item{colnum}{a numeric, the number of colnum for the plot.}

\item{plane}{a vector plot sequence.}

\item{xlab}{a character for a label in the x axis.}

\item{ylab}{a character for a label in the y axis.}

\item{axes}{a logical. TRUE presents the axes.}

\item{oma}{a vector for outer margin area.}

\item{mar}{a vector for margin.}

\item{bg}{a character for color of background.}

\item{paron}{a logical. TRUE means par is used.}

\item{cross.hair}{a logical.}

\item{chxy}{a vector cross hair position to be plotted.}

\item{color.bar}{a logical.}

\item{regionplot}{a logical.}

\item{atlasdataset}{a matrix or data.frame. colnames shold include "ROIid" and "ROIname".}

\item{regionname}{a character.}

\item{regionlegend}{a logical.}

\item{atlasname}{a character.}

\item{ROIids}{a vector}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This is a function for plotting an image. The analysis result can be overcoated on the template.
}
\details{
\code{coat} requires a image array.
}
\examples{

data(exbrain)
coat(exbrain)

}
