% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowdiff.R
\name{rowdiff}
\alias{rowdiff}
\title{Get row differences between values}
\usage{
rowdiff(
  df,
  direction = "forward",
  exclude = NULL,
  na.rm = FALSE,
  na_action = NULL,
  ...
)
}
\arguments{
\item{df}{The data set for which differences are required}

\item{direction}{One of forward and reverse. The default is forward meaning the differences
are calculated
in such a way that the difference
between the current value and the next is returned}

\item{exclude}{A character vector specifying what classes should be removed. See examples below}

\item{na.rm}{Logical. Should missing values be removed? The missing values referred to are those introduced during the calculation ie when subtracting a row with itself.
Defaults to FALSE.}

\item{na_action}{If na.rm is TRUE, how should missing values be replaced? Depending on the 
value as set out in `na_replace`, the value can be replaced as per the user's requirement.}

\item{...}{Other arguments to `na_replace`.}
}
\value{
A data.frame object of row differences
}
\description{
This function returns the differences between rows depending on the user's choice.
}
\examples{
# Remove factor columns
rowdiff(iris,exclude = "factor",direction = "reverse")
rowdiff(iris[1:5,], exclude="factor",
     na.rm = TRUE, na_action = "get_mode",
     direction = "reverse")
}
\seealso{
\code{\link{na_replace}}
}
