% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_simple_mediation_latent.R
\docType{data}
\name{simple_mediation_latent}
\alias{simple_mediation_latent}
\title{Sample Dataset: A Simple
Latent Mediation Model}
\format{
A data frame with 200 rows
and 11 variables:
\describe{
\item{x1}{Indicator of \code{fx}. Numeric.}
\item{x2}{Indicator of \code{fx}. Numeric.}
\item{x3}{Indicator of \code{fx}. Numeric.}
\item{m1}{Indicator of \code{fm}. Numeric.}
\item{m2}{Indicator of \code{fm}. Numeric.}
\item{m3}{Indicator of \code{fm}. Numeric.}
\item{y1}{Indicator of \code{fy}. Numeric.}
\item{y2}{Indicator of \code{fy}. Numeric.}
\item{y3}{Indicator of \code{fy}. Numeric.}
}
}
\usage{
simple_mediation_latent
}
\description{
Generated from a simple
mediation model among xthree latent
factors, \code{fx}, \code{fm}, and \code{fy}, xeach
has three indicators.
}
\details{
The model:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fx =~ x1 + x2 + x3
fm =~ m1 + m2 + m3
fy =~ y1 + y2 + y3
fm ~ a * fx
fy ~ b * fm + cp * fx
indirect := a * b
}\if{html}{\out{</div>}}
}
\keyword{datasets}
