% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_parallel}
\alias{data_parallel}
\title{Sample Dataset: Parallel Mediation}
\format{
A data frame with 100 rows and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{m1}{Mediator 1. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_parallel
}
\description{
A parallel mediation model.
}
\examples{
library(lavaan)
data(data_parallel)
mod <-
"
m1 ~ a1 * x + c1 + c2
m2 ~ a2 * x + c1 + c2
y ~ b2 * m2 + b1 * m1 + x + c1 + c2
indirect1 := a1 * b1
indirect2 := a2 * b2
indirect := a1 * b1 + a2 * b2
"
fit <- sem(mod, data_parallel,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 4, 7, 8, 27:29), ]
}
\keyword{datasets}
