% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformat.R
\name{reformat}
\alias{reformat}
\alias{to_uniplex}
\alias{to_undirected}
\alias{to_directed}
\alias{to_redirected}
\alias{to_reciprocated}
\alias{to_acyclic}
\alias{to_unweighted}
\alias{to_unsigned}
\alias{to_unnamed}
\alias{to_named}
\alias{to_simplex}
\alias{to_onemode}
\alias{to_multilevel}
\alias{to_twomode}
\title{Tools for reformatting networks, graphs, and matrices}
\usage{
to_uniplex(.data, edge)

to_undirected(.data)

to_directed(.data)

to_redirected(.data)

to_reciprocated(.data)

to_acyclic(.data)

to_unweighted(.data, threshold = 1)

to_unsigned(.data, keep = c("positive", "negative"))

to_unnamed(.data)

to_named(.data, names = NULL)

to_simplex(.data)

to_onemode(.data)

to_multilevel(.data)

to_twomode(.data, mark)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{edge}{Character string naming an edge attribute to retain from a graph.}

\item{threshold}{For a matrix, the threshold to binarise/dichotomise at.}

\item{keep}{In the case of a signed network, whether to retain
the "positive" or "negative" ties.}

\item{names}{Character vector of the node names. NULL by default.}

\item{mark}{A logical vector marking two types or modes.
By default "type".}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions offer tools for reformatting migraph-consistent objects
(matrices, igraph, tidygraph, or network objects).
Unlike the \verb{as_*()} group of functions,
these functions always return the same object type as they are given,
only transforming these objects' properties.

Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_acyclic \tab 0 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_directed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_multilevel \tab 0 \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_named \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_onemode \tab 0 \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_reciprocated \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_redirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_simplex \tab 0 \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_twomode \tab 0 \tab 1 \tab 0 \tab 1 \tab 1 \cr
   to_undirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_uniplex \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unnamed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unsigned \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unweighted \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\section{Functions}{
\itemize{
\item \code{to_uniplex()}: Returns an object that includes only a single type of tie

\item \code{to_undirected()}: Returns an object that has any edge direction removed,
so that any pair of nodes with at least one directed edge will be
connected by an undirected edge in the new network.
This is equivalent to the "collapse" mode in \code{{igraph}}.

\item \code{to_directed()}: Returns a directed object.
Note that ties' direction will be randomly assigned.
To flip the direction, use \code{to_redirected()}.
To match the direction, use \code{to_reciprocated()}.

\item \code{to_redirected()}: Returns an object that has any edge direction transposed,
or flipped, so that senders become receivers and receivers become senders.
This essentially has no effect on undirected networks or reciprocated ties.

\item \code{to_reciprocated()}: Returns an object where all ties are reciprocated.

\item \code{to_acyclic()}: Returns an object where all ties are acyclic.

\item \code{to_unweighted()}: Returns an object that has all edge weights removed.

\item \code{to_unsigned()}: Returns a network with either just the "positive" ties
or just the "negative" ties

\item \code{to_unnamed()}: Returns an object with all vertex names removed

\item \code{to_named()}: Returns an object that has random vertex names added

\item \code{to_simplex()}: Returns an object that has all loops or self-ties removed

\item \code{to_onemode()}: Returns an object that has any type/mode attributes removed,
but otherwise includes all the same nodes and ties.
Note that this is not the same as \code{to_mode1()} or \code{to_mode2()},
which return only some of the nodes and new ties established by coincidence.

\item \code{to_multilevel()}: Returns a network that is not divided into two mode types
but embeds two or more modes into a multimodal network structure.

\item \code{to_twomode()}: Returns a network that divides the nodes into two mode types.

}}
\examples{
as_tidygraph(create_filled(5)) \%>\%
  mutate_ties(type = sample(1:2, 10, replace = TRUE)) \%>\%
  to_uniplex("type")
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{split}()},
\code{\link{tidy}},
\code{\link{transform}()}
}
\concept{manipulations}
