% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_nodes.R
\name{mark_diff}
\alias{mark_diff}
\alias{node_is_latent}
\alias{node_is_infected}
\alias{node_is_recovered}
\alias{node_is_exposed}
\title{Marking nodes based on diffusion properties}
\usage{
node_is_latent(.data, time = 0)

node_is_infected(.data, time = 0)

node_is_recovered(.data, time = 0)

node_is_exposed(.data, mark)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{time}{A time step at which nodes are identified.}

\item{mark}{vector denoting which nodes are infected}
}
\description{
These functions return logical vectors the length of the
nodes in a network identifying which hold certain properties or positions in the network.
\itemize{
\item \code{node_is_infected()} marks nodes that are infected by a particular time point.
\item \code{node_is_exposed()} marks nodes that are exposed to a given (other) mark.
\item \code{node_is_latent()} marks nodes that are latent at a particular time point.
\item \code{node_is_recovered()} marks nodes that are recovered at a particular time point.
}
}
\section{Exposed}{

\code{node_is_exposed()} is similar to \code{node_exposure()},
but returns a mark (TRUE/FALSE) vector indicating which nodes
are currently exposed to the diffusion content.
This diffusion content can be expressed in the 'mark' argument.
If no 'mark' argument is provided,
and '.data' is a diff_model object,
then the function will return nodes exposure to the seed nodes
in that diffusion.
}

\examples{
  # To mark nodes that are latent by a particular time point
  node_is_latent(play_diffusion(create_tree(6), latency = 1), time = 1)
  # To mark nodes that are infected by a particular time point
  node_is_infected(play_diffusion(create_tree(6)), time = 1)
  # To mark nodes that are recovered by a particular time point
  node_is_recovered(play_diffusion(create_tree(6), recovery = 0.5), time = 3)
  # To mark which nodes are currently exposed
  (expos <- node_is_exposed(manynet::create_tree(14), mark = c(1,3)))
  which(expos)
}
\seealso{
Other marks: 
\code{\link{mark_nodes}},
\code{\link{mark_select}},
\code{\link{mark_tie_select}},
\code{\link{mark_ties}},
\code{\link{mark_triangles}}
}
\concept{marks}
