% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_munic.R
\name{esp_get_munic}
\alias{esp_get_munic}
\alias{esp_get_munic_siane}
\title{Get municipalities boundaries of Spain}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/}{GISCO API}

IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_munic(
  year = "2019",
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  region = NULL,
  munic = NULL,
  moveCAN = TRUE
)

esp_get_munic_siane(
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = 3,
  region = NULL,
  munic = NULL,
  moveCAN = TRUE,
  rawcols = FALSE
)
}
\arguments{
\item{year}{Release year. See Details for years available.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with:
\itemize{
\item \code{options(mapSpain_cache_dir = "path/to/dir")}.
}

See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{region}{A vector of names and/or codes for provinces
or \code{NULL} to get all the municipalities. See Details.}

\item{munic}{A name or regex expression with the names of the required
municipalities. \code{NULL} would not produce any filtering.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates.}

\item{resolution}{Resolution of the polygon. Values available are
"3", "6.5" or  "10".}

\item{rawcols}{Logical. Setting this to \code{TRUE} would add the raw columns of
the dataset provided by IGN.}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a simple feature (\code{sf}) object containing the
municipalities boundaries of Spain.

\code{esp_get_munic} uses GISCO (Eurostat) as source.

\code{esp_get_munic_siane} uses CartoBase ANE as source, provided by Instituto
Geografico Nacional (IGN), \url{http://www.ign.es/web/ign/portal}. Years
available are 2005 up to today.
}
\details{
When using \code{region} you can use and mix names and NUTS codes
(levels 1, 2 or 3), ISO codes (corresponding to level 2 or 3) or
\code{cpro}.

When calling a superior level (Province, Autonomous Community or NUTS1) ,
all the municipalities of that level would be added.

On \code{esp_get_munic} years available are: 2001, 2004, 2006,
2008, 2010, 2013 and any year between 2016 and 2019.

On \code{esp_get_munic_siane}, \code{year} could be passed as a single
year ("YYYY" format, as end of year) or as a specific
date ("YYYY-MM-DD" format). Historical information starts as of 2005.
}
\examples{

Base <- esp_get_munic(region = c("Castilla y Leon"))
SAN <-
  esp_get_munic(
    region = c("Castilla y Leon"),
    munic = c("^San ", "^Santa ")
  )

library(tmap)
tm_shape(Base) +
  tm_polygons("#FDFBEA", border.col = "#656565", border.alpha = 0.3) +
  tm_shape(SAN) +
  tm_polygons("#C12838", border.col = "#656565") +
  tm_layout(
    main.title = paste0(
      "Municipalities named under Saints (San, Santa)",
      "\nCastilla y Leon, Spain"
    ),
    main.title.size = .8
  )
}
\seealso{
\code{\link[=esp_get_nuts]{esp_get_nuts()}}, \code{\link{esp_munic.sf}}, \code{\link{esp_codelist}}.
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{political}
