% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_cache.R
\name{esp_set_cache_dir}
\alias{esp_set_cache_dir}
\title{Set your \code{mapSpain} cache dir}
\usage{
esp_set_cache_dir(
  cache_dir = rappdirs::user_cache_dir("mapSpain", "R"),
  overwrite = TRUE,
  install = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{cache_dir}{A path to a cache directory.}

\item{overwrite}{If this is set to \code{TRUE}, it will overwrite an existing
\code{MAPSPAIN_CACHE_DIR} that you already have in local machine.}

\item{install}{if \code{TRUE}, will install the key in your local machine for
use in future sessions.  Defaults to \code{FALSE.}}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
Invisible value
}
\description{
This function will store your \code{cache_dir} path on your local machine and
would load it for future sessions. Type \code{Sys.getenv("MAPSPAIN_CACHE_DIR")} to
find your cached path.

Alternatively, you can store the \code{cache_dir} manually with the following
options:
\itemize{
\item Run \code{Sys.setenv(MAPSPAIN_CACHE_DIR = "cache_dir")}. You would need to
run this command on each session (Similar to \code{install = FALSE}).
\item Set \code{options(mapSpain_cache_dir = "cache_dir")}. Similar to the previous
option.
\item Write this line on your .Renviron file: \code{MAPSPAIN_CACHE_DIR = "cache_dir"}
(same behavior than \code{install = TRUE}). This would store your \code{cache_dir}
permanently.
}
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
esp_set_cache_dir(verbose = TRUE)
}

Sys.getenv("MAPSPAIN_CACHE_DIR")
}
\seealso{
\code{\link[rappdirs:user_cache_dir]{rappdirs::user_cache_dir()}}
}
\concept{helper}
