% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_nuts.sf}
\alias{esp_nuts.sf}
\title{All NUTS \code{POLYGON} object of Spain}
\format{
A \code{POLYGON} data frame (resolution: 1:1million, EPSG:4258) object with
86 rows and fields:
\describe{
\item{COAST_TYPE}{COAST_TYPE}
\item{FID}{FID}
\item{NUTS_NAME}{NUTS name on local alphabet}
\item{MOUNT_TYPE}{MOUNT_TYPE}
\item{NAME_LATN}{Name on Latin characters}
\item{CNTR_CODE}{Eurostat Country code}
\item{URBN_TYPE}{URBN_TYPE}
\item{NUTS_ID}{NUTS identifier}
\item{LEVL_CODE}{NUTS level code (0,1,2,3)}
\item{geometry}{geometry field}
}
}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/nuts/}, file
\code{NUTS_RG_20M_2016_4326.geojson}.
}
\description{
A \pkg{sf} object including all NUTS levels of Spain as provided by
GISCO (2016 version).
}
\examples{
data("esp_nuts.sf")

nuts <- esp_nuts.sf

# Select NUTS 3
nuts3 <- esp_nuts.sf[esp_nuts.sf$LEVL_CODE == 3, ]

# Combine with full shape

spain <- esp_get_country(moveCAN = FALSE)

# Plot Urban Type: See
# https://ec.europa.eu/eurostat/web/rural-development/methodology

library(ggplot2)

nuts3$URBN_TYPE_cat <- as.factor(nuts3$URBN_TYPE)

levels(nuts3$URBN_TYPE_cat)
levels(nuts3$URBN_TYPE_cat) <- c("Urban", "Intermediate", "Rural")

ggplot(nuts3) +
  geom_sf(aes(fill = URBN_TYPE_cat), linewidth = .1) +
  scale_fill_manual(values = c("grey80", "#FFC183", "#68AC20")) +
  labs(
    title = "NUTS3 levels of Spain",
    fill = "Urban topology"
  ) +
  theme_linedraw() +
  theme(
    legend.position = c(.8, .2)
  )
}
\seealso{
Other datasets: 
\code{\link{esp_codelist}},
\code{\link{esp_munic.sf}},
\code{\link{esp_tiles_providers}},
\code{\link{pobmun19}}

Other nuts: 
\code{\link{esp_get_nuts}()}
}
\concept{datasets}
\concept{nuts}
