% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{mb_batch_geocode}
\alias{mb_batch_geocode}
\title{Geocode addresses or locations in bulk using the Mapbox Batch Geocoding API}
\usage{
mb_batch_geocode(
  data,
  search_column = NULL,
  address_line1 = NULL,
  address_number = NULL,
  street = NULL,
  block = NULL,
  place = NULL,
  region = NULL,
  postcode = NULL,
  locality = NULL,
  neighborhood = NULL,
  country = NULL,
  permanent = FALSE,
  limit = 1,
  search_within = NULL,
  language = NULL,
  types = NULL,
  proximity = NULL,
  worldview = NULL,
  allow_large_job = FALSE,
  access_token = NULL,
  sf = TRUE
)
}
\arguments{
\item{data}{An input data frame}

\item{search_column}{A column that contains a description of the place to geocode, or a full address.  \code{search_column} cannot be used with address component arguments.}

\item{address_line1}{The name of a column in \code{data} that contains the first line of an address, e.g. "1600 Pennsylvania Ave NW"}

\item{address_number}{The name of a column in \code{data} that contains the address number, e.g. "1600".  Not required when \code{address_line1} is used.}

\item{street}{The name of a column in \code{data} that contains the street name, e.g. "Pennsylvania Ave NW".  Not required when \code{address_line1} is used.}

\item{block}{The name of a column in \code{data} that describes the block, used in some Japanese addresses.}

\item{place}{The name of a column in \code{data} that contains the place name; typically a city, village, or municipality, e.g. "Washington"}

\item{region}{The name of a column in \code{data} that represents sub-national administrative features, such as states in Mexico or the United States.  Example: "DC"}

\item{postcode}{The name of a column in \code{data} representing the postal code of the address; this will be a ZIP code in the United States, e.g. "20500"}

\item{locality}{The name of a column in \code{data} that describes official sub-city locations, such as arrondissements in France.}

\item{neighborhood}{The name of a column in \code{data} that represents a colloquial neighborhood name for the location.}

\item{country}{A character string or vector of ISO 3166 alpha-2 country codes within which you would like to limit your search.}

\item{permanent}{Either FALSE (the default) when results are not intended to be stored, or TRUE if the results are planned to be stored.}

\item{limit}{How many results to return per address.  This is not currently accessible for users and can only be 1.}

\item{search_within}{An \code{sf} object, or vector representing a bounding box of
format \code{c(min_longitude, min_latitude, max_longitude, max_latitude)} used
to limit search results. Defaults to NULL.}

\item{language}{The user's language, which can help with interpretation of
queries. Available languages are found at
\url{https://docs.mapbox.com/api/search/#language-coverage}.}

\item{types}{A vector of feature types to limit to which the search should be
limited. Available options include \code{'country'}, \code{'region'}, \code{'postcode'},
\code{'district'}, \code{'place'}, \code{'locality'}, \code{'neighborhood'}, \code{'address'}, \code{street}, \code{block}, \code{address}. and \code{'secondary_address'}. If left blank, all types will be searched.}

\item{proximity}{proximity Either a vector of coordinates or an IP address string to bias the results to favor locations near to the input location.}

\item{worldview}{Returns features intended for different regional or cultural groups.  The US (\code{'us'}) world view is returned by default.}

\item{allow_large_job}{A boolean indicating that the user is OK with potential charges incurred to their account due to a large geocoding job (over 1000 addresses).  The Mapbox Free Tier includes 100,000 free geocodes per month.  Defaults to \code{FALSE}.}

\item{access_token}{The Mapbox access token (required); can be set with
\code{\link[=mb_access_token]{mb_access_token()}}}

\item{sf}{A boolean that determines whether the output will be an sf POINT object (\code{TRUE}, the default) or a regular data frame (\code{FALSE}).}
}
\value{
The input dataset as an sf POINT object representing the geocoded locations, or the input dataset with longitude, latitude, and matched address columns included.
}
\description{
Geocode addresses or locations in bulk using the Mapbox Batch Geocoding API
}
