% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{compare}
\alias{compare}
\title{Create a Compare slider widget}
\usage{
compare(
  map1,
  map2,
  width = "100\%",
  height = NULL,
  elementId = NULL,
  mousemove = FALSE,
  orientation = "vertical"
)
}
\arguments{
\item{map1}{A \code{mapboxgl} or \code{maplibre} object representing the first map.}

\item{map2}{A \code{mapboxgl} or \code{maplibre} object representing the second map.}

\item{width}{Width of the map container.}

\item{height}{Height of the map container.}

\item{elementId}{An optional string specifying the ID of the container for the comparison. If NULL, a unique ID will be generated.}

\item{mousemove}{A logical value indicating whether to enable swiping during cursor movement (rather than only when clicked).}

\item{orientation}{A string specifying the orientation of the swiper, either "horizontal" or "vertical".}
}
\value{
A comparison widget.
}
\description{
This function creates a comparison view between two Mapbox GL or Maplibre GL maps, allowing users to swipe between the two maps to compare different styles or data layers.
}
\examples{
\dontrun{
library(mapgl)

library(mapgl)

m1 <- mapboxgl(style = mapbox_style("light"))

m2 <- mapboxgl(style = mapbox_style("dark"))

compare(m1, m2)
}
}
