% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{map_legends}
\alias{map_legends}
\alias{add_legend}
\alias{add_categorical_legend}
\alias{add_continuous_legend}
\title{Add legends to Mapbox GL and MapLibre GL maps}
\usage{
add_legend(
  map,
  legend_title,
  values,
  colors,
  type = c("continuous", "categorical"),
  circular_patches = FALSE,
  patch_shape = "square",
  position = "top-left",
  sizes = NULL,
  add = FALSE,
  unique_id = NULL,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)

add_categorical_legend(
  map,
  legend_title,
  values,
  colors,
  circular_patches = FALSE,
  patch_shape = "square",
  position = "top-left",
  unique_id = NULL,
  sizes = NULL,
  add = FALSE,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)

add_continuous_legend(
  map,
  legend_title,
  values,
  colors,
  position = "top-left",
  unique_id = NULL,
  add = FALSE,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL,
  style = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} function.}

\item{legend_title}{The title of the legend.}

\item{values}{The values being represented on the map (either a vector of categories or a vector of stops).}

\item{colors}{The corresponding colors for the values (either a vector of colors, a single color, or an interpolate function).}

\item{type}{One of "continuous" or "categorical" (for \code{add_legend} only).}

\item{circular_patches}{(Deprecated) Logical, whether to use circular patches in the legend. Use \code{patch_shape = "circle"} instead.}

\item{patch_shape}{Character or sf object, the shape of patches to use in categorical legends. Can be one of the built-in shapes ("square", "circle", "line", "hexagon"), a custom SVG string, or an sf object with POLYGON or MULTIPOLYGON geometry (which will be automatically converted to SVG). Default is "square".}

\item{position}{The position of the legend on the map (one of "top-left", "bottom-left", "top-right", "bottom-right").}

\item{sizes}{An optional numeric vector of sizes for the legend patches, or a single numeric value (only for categorical legends). For line patches, this controls the line thickness.}

\item{add}{Logical, whether to add this legend to existing legends (TRUE) or replace existing legends (FALSE). Default is FALSE.}

\item{unique_id}{Optional. A unique identifier for the legend. If not provided, a random ID will be generated.}

\item{width}{The width of the legend. Can be specified in pixels (e.g., "250px") or as "auto". Default is NULL, which uses the built-in default.}

\item{layer_id}{The ID of the layer that this legend is associated with. If provided, the legend will be shown/hidden when the layer visibility is toggled.}

\item{margin_top}{Custom top margin in pixels, allowing for fine control over legend positioning. Default is NULL (uses standard positioning).}

\item{margin_right}{Custom right margin in pixels. Default is NULL.}

\item{margin_bottom}{Custom bottom margin in pixels. Default is NULL.}

\item{margin_left}{Custom left margin in pixels. Default is NULL.}

\item{style}{Optional styling options created by \code{legend_style()} or a list of style options.}
}
\value{
The updated map object with the legend added.
}
\description{
These functions add categorical and continuous legends to maps. Use \code{legend_style()}
to customize appearance and \code{clear_legend()} to remove legends.
}
\examples{
\dontrun{
# Basic categorical legend
add_legend(map, "Population",
          values = c("Low", "Medium", "High"),
          colors = c("blue", "yellow", "red"),
          type = "categorical")

# Continuous legend with custom styling
add_legend(map, "Income",
          values = c(0, 50000, 100000),
          colors = c("blue", "yellow", "red"),
          type = "continuous",
          style = list(
            background_color = "white",
            background_opacity = 0.9,
            border_width = 2,
            border_color = "navy",
            text_color = "darkblue",
            font_family = "Times New Roman",
            title_font_weight = "bold"
          ))

# Legend with custom styling using a list
add_legend(map, "Temperature",
          values = c(0, 50, 100),
          colors = c("blue", "yellow", "red"),
          type = "continuous",
          style = list(
            background_color = "#f0f0f0",
            title_size = 16,
            text_size = 12,
            shadow = TRUE,
            shadow_color = "rgba(0,0,0,0.1)",
            shadow_size = 8
          ))

# Dark legend with white element borders
add_legend(map, "Elevation",
          values = c(0, 1000, 2000, 3000),
          colors = c("#2c7bb6", "#abd9e9", "#fdae61", "#d7191c"),
          type = "continuous",
          style = list(
            background_color = "#2c3e50",
            text_color = "white",
            title_color = "white",
            element_border_color = "white",
            element_border_width = 1
          ))

# Categorical legend with circular patches
add_categorical_legend(
    map = map,
    legend_title = "Population",
    values = c("Low", "Medium", "High"),
    colors = c("#FED976", "#FEB24C", "#FD8D3C"),
    patch_shape = "circle",
    sizes = c(10, 15, 20),
    style = list(
      background_opacity = 0.95,
      border_width = 1,
      border_color = "gray",
      title_color = "navy",
      element_border_color = "black",
      element_border_width = 1
    )
)

# Legend with line patches for line layers
add_categorical_legend(
    map = map,
    legend_title = "Road Type",
    values = c("Highway", "Primary", "Secondary"),
    colors = c("#000000", "#333333", "#666666"),
    patch_shape = "line",
    sizes = c(5, 3, 1)  # Line thickness in pixels
)

# Legend with hexagon patches (e.g., for H3 data)
add_categorical_legend(
    map = map,
    legend_title = "H3 Hexagon Categories",
    values = c("Urban", "Suburban", "Rural"),
    colors = c("#8B0000", "#FF6347", "#90EE90"),
    patch_shape = "hexagon",
    sizes = 25
)

# Custom SVG shapes - star
add_categorical_legend(
    map = map,
    legend_title = "Ratings",
    values = c("5 Star", "4 Star", "3 Star"),
    colors = c("#FFD700", "#FFA500", "#FF6347"),
    patch_shape = paste0('<path d="M50,5 L61,35 L95,35 L68,57 L79,91 L50,70 ',
                         'L21,91 L32,57 L5,35 L39,35 Z" />')
)

# Using sf objects directly as patch shapes
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))
county_shape <- nc[1, ]  # Get first county

add_categorical_legend(
    map = map,
    legend_title = "County Types",
    values = c("Rural", "Urban", "Suburban"),
    colors = c("#228B22", "#8B0000", "#FFD700"),
    patch_shape = county_shape  # sf object automatically converted to SVG
)

# For advanced users needing custom conversion options
custom_svg <- mapgl:::.sf_to_svg(county_shape, simplify = TRUE,
                                  tolerance = 0.001, fit_viewbox = TRUE)
add_categorical_legend(
    map = map,
    legend_title = "Custom Converted Shape",
    values = c("Type A"),
    colors = c("#4169E1"),
    patch_shape = custom_svg
)

}
}
