% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emissions.R
\docType{data}
\name{emissions}
\alias{emissions}
\title{Calculate emission statistics}
\format{
A tibble with a column for years and emissions (in Mg)
}
\description{
This functions allows to efficiently calculate emission statistics for
areas of interest. For each year in the analysis timeframe, the forest losses
from Hansen et al. (2013) are overlayed with the respective emission layer
from Harris et al. (2021) and area-wise emission statistics are calculated
for each year.
The required resources for this indicator are:
\itemize{
\item \link{treecover2000}
\item \link{lossyear}
\item \link{greenhouse}.
}
}
\details{
The following arguments can be set:
\describe{
\item{min_size}{The minum size of a forest patch to be considered as forest in ha.}
\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
                        package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources(
    resources = c("treecover2000", "lossyear", "greenhouse"),
    vers_treecover = "GFC-2020-v1.8", vers_lossyear = "GFC-2020-v1.8"
  ) \%>\%
  calc_indicators("emissions", min_size = 1, min_cover = 30) \%>\%
  tidyr::unnest(emissions)))
}
\keyword{indicator}
