% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_deforestation_drivers.R
\docType{data}
\name{deforestation_drivers}
\alias{deforestation_drivers}
\title{Calculate deforestation drivers}
\format{
A tibble with 3 columns indicating the class of a deforestation driver,
the absolute area in ha, and the percentage in relation to the total
area of forest loss as indicated by the Fritz et al. (2022) resource.
}
\description{
This function extracts areal statistics for the drivers of deforestation
based on the data source produced by Fritz et al (2022). The required
resource is:
\itemize{
\item \link{fritz_et_al}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2021,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources("fritz_et_al", res_drivers = 100) \%>\%
  calc_indicators("deforestation_drivers") \%>\%
  tidyr::unnest(deforestation_drivers)

aoi
}
}
\keyword{indicator}
