% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_elevation.R
\name{elevation}
\alias{elevation}
\alias{calc_elevation}
\title{Calculate elevation statistics}
\usage{
calc_elevation(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character "mean", "median" or "sd".}
}
\value{
A function that returns a tibble with a column for each statistics.
}
\description{
This function allows to calculate elevation statistics for
polygons. For each polygon, the desired statistic(s)
are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{nasa_srtm}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_nasa_srtm()) \%>\%
  calc_indicators(
    calc_elevation(engine = "extract", stats = c("mean", "median", "sd", "var"))
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
