% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_polymapR.R
\name{import_phased_maplist_from_polymapR}
\alias{import_phased_maplist_from_polymapR}
\title{Import phased map list from polymapR}
\usage{
import_phased_maplist_from_polymapR(maplist, mappoly.data, ploidy = NULL)
}
\arguments{
\item{maplist}{a list of phased maps obtained using function 
\code{create_phased_maplist} from package \code{polymapR}}

\item{mappoly.data}{a dataset used to obtain \code{maplist}, 
converted into class \code{mappoly.data}}

\item{ploidy}{the ploidy level}
}
\description{
Function to import phased map lists from polymapR
}
\examples{
require(polymapR)
## Loading polymapR example
data("integrated.maplist", "screened_data3", "marker_assignments_P1","marker_assignments_P2")
maplist <- create_phased_maplist(maplist = integrated.maplist,
                                 dosage_matrix.conv = screened_data3,
                                 marker_assignment.1=marker_assignments_P1,
                                 marker_assignment.2=marker_assignments_P2,
                                 ploidy = 4)
 ## Importing polymapR dataset                                
 mappoly.data <- import_data_from_polymapR(screened_data3, 4)
 plot(mappoly.data) 
 
 ## Importing polymapR phased maplist
 mappoly.maplist <- import_phased_maplist_from_polymapR(maplist, mappoly.data)
 plot_map_list(mappoly.maplist)
 ## plot phased map
 plot(mappoly.maplist[[1]])
 ## plot a segment of phased map (from 0 to 20 cM)
 plot(mappoly.maplist[[1]], mrk.names = TRUE, left.lim = 0, right.lim = 20, cex = .7)

}
\references{
Bourke PM et al: (2019) PolymapR — linkage analysis and genetic map 
    construction from F1 populations of outcrossing polyploids. 
    _Bioinformatics_ 34:3496–3502.
    \url{https://doi.org/10.1093/bioinformatics/bty1002}

    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari \email{mmollin@ncsu.edu}
}
