% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_genoprob_one_parent.R
\name{calc_genoprob_one_parent}
\alias{calc_genoprob_one_parent}
\title{Compute conditional probabilities of the genotype (one informative parent)}
\usage{
calc_genoprob_one_parent(
  input.map,
  step = 0,
  info.parent = 1,
  uninfo.parent = 2,
  global.err = 0,
  phase.config = "best",
  verbose = TRUE
)
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map} (with exceptions)}

\item{step}{Maximum distance (in cM) between positions at which
the genotype probabilities are calculated, though for
step = 0, probabilities are calculated only at the
marker locations.}

\item{info.parent}{index for informative parent}

\item{uninfo.parent}{index for uninformative parent}

\item{global.err}{the assumed global error rate (default = 0.0)}

\item{phase.config}{which phase configuration should be used. "best" (default)
will choose the phase configuration associated with the
maximum likelihood}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class 'mappoly.genoprob' which has two elements: a tridimensional
array containing the probabilities of all possible genotypes for each individual
in each marker position; and the marker sequence with it's recombination frequencies
}
\description{
Conditional genotype probabilities are calculated for each marker
position and each individual given a map
}
\examples{
 ## tetraploid example
 map <- solcap.dose.map[[1]]
 s <- make_seq_mappoly(map)
 map1 <- est_rf_hmm_single_one_parent(input.seq = s, 
                                      input.ph.single = map$maps[[1]]$seq.ph,
                                      info.parent = 1, 
                                      uninfo.parent = 2, 
                                      tol = 10e-4)
 plot(map1)                                     
 probs <- calc_genoprob_one_parent(input.map = map1, 
                                   info.parent = 1, 
                                   uninfo.parent = 2, 
                                   step = 1)
 probs
 ## displaying individual 1, 6 genotypic states
 ## (rows) across linkage group 1 (columns)                          
 image(t(probs$probs[,,2]))

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
