% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_annotation.R
\name{mf_annotation}
\alias{mf_annotation}
\title{Plot an annotation}
\usage{
mf_annotation(
  x,
  txt,
  pos = "topright",
  cex = 0.8,
  col_arrow,
  col_txt,
  halo = FALSE,
  bg,
  s = 1,
  ...
)
}
\arguments{
\item{x}{an sf object with 1 row, a couple of coordinates (c(x, y)).}

\item{txt}{the text to display}

\item{pos}{position of the text, one of "topleft", "topright", "bottomright",
"bottomleft" or "interactive"}

\item{cex}{size of the text}

\item{col_arrow}{arrow color}

\item{col_txt}{text color}

\item{halo}{add a halo around the text}

\item{bg}{halo color}

\item{s}{arrow size (min=1)}

\item{...}{further \link{text} arguments.}
}
\value{
No return value, an annotation is displayed.
}
\description{
Plot an annotation on a map.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_annotation(
  x = c(711167.8, 1614764),
  txt = "Look!\nImportant feature\nhere!",
  pos = "bottomleft", cex = 1.2, font = 2,
  halo = TRUE, s = 1.5
)

mf_annotation(
  x = mtq[20, ],
  txt = "This is less\nimportant",
  cex = .7, font = 3, s = 1.3
)
}
