% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get_tiles}
\alias{get_tiles}
\title{Get basemap tiles from map servers}
\usage{
get_tiles(
  x,
  provider = "OpenStreetMap",
  zoom,
  crop = FALSE,
  verbose = FALSE,
  apikey,
  cachedir,
  forceDownload = FALSE
)
}
\arguments{
\item{x}{an sf, sfc, bbox, SpatRaster, SpatVerctor or SpatExtent object.
If \code{x} is a SpatExtent it
must express coordinates in lon/lat WGS84 (epsg:4326).}

\item{provider}{the tile server from which to get the map. It can be a name
(see Details for providers) or a named list like this one: \code{
provider = list(src = "name of the source",
q = "server address", sub = "subdomains", cit = "how to cite the tiles")}
(see Examples).}

\item{zoom}{the zoom level (see Details).}

\item{crop}{TRUE if results should be cropped to the specified x extent,
FALSE otherwise. If x is an sf object with one POINT, crop is set to FALSE.}

\item{verbose}{if TRUE, tiles filepaths, zoom level and citation are displayed.}

\item{apikey}{API key, needed for Thunderforest servers}

\item{cachedir}{name of a directory used to cache tiles. If not set, tiles
are cached in a \link[base:tempfile]{tempdir} folder.}

\item{forceDownload}{if TRUE, existing cached tiles may be overwritten}
}
\value{
A SpatRaster is returned.
}
\description{
Get map tiles based on a spatial object extent. Maps can be
fetched from various map servers.
}
\details{
Zoom levels are described on the OpenStreetMap wiki:
\url{https://wiki.openstreetmap.org/wiki/Zoom_levels}. \cr\cr
Providers: \cr
"OpenStreetMap.MapnikBW", "OpenStreetMap", "OpenStreetMap.DE",
"OpenStreetMap.France", "OpenStreetMap.HOT", \cr
"Stamen.Toner",
"Stamen.TonerBackground", "Stamen.TonerHybrid", "Stamen.TonerLines",
"Stamen.TonerLabels", "Stamen.TonerLite", "Stamen.Watercolor",
"Stamen.Terrain", "Stamen.TerrainBackground", "Stamen.TerrainLabels",\cr
"Esri.WorldStreetMap", "Esri.DeLorme", "Esri.WorldTopoMap", "Esri.WorldImagery",
"Esri.WorldTerrain", "Esri.WorldShadedRelief", "Esri.OceanBasemap",
"Esri.NatGeoWorldMap", "Esri.WorldGrayCanvas",\cr
"CartoDB.Positron",
"CartoDB.PositronNoLabels", "CartoDB.PositronOnlyLabels", "CartoDB.DarkMatter",
"CartoDB.DarkMatterNoLabels", "CartoDB.DarkMatterOnlyLabels",
"CartoDB.Voyager", "CartoDB.VoyagerNoLabels", "CartoDB.VoyagerOnlyLabels",\cr
 "Thunderforest.OpenCycleMap", "Thunderforest.Transport",
"Thunderforest.TransportDark", "Thunderforest.SpinalMap", "Thunderforest.Landscape",
"Thunderforest.Outdoors", "Thunderforest.Pioneer", "Thunderforest.MobileAtlas",
"Thunderforest.Neighbourhood",\cr
"OpenTopoMap",\cr
"HikeBike", \cr
"Wikimedia",\cr
}
\examples{
library(sf)
library(maptiles)
nc <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc_osm <- get_tiles(nc, crop = TRUE, zoom = 6)
plot_tiles(nc_osm)

# Download tiles from OSM, no labels
osmnolbl <- list(
  src = 'osmnolabel',
  q = 'https://{s}.tiles.wmflabs.org/osm-no-labels/{z}/{x}/{y}.png',
  sub = c('a','b', 'c'),
  cit = '© OpenStreetMap contributors.'
)
# dowload tiles and compose raster (SpatRaster)
nc_osmnolbl <- get_tiles(x = nc, provider = osmnolbl, crop = TRUE,
                         zoom = 6, verbose = TRUE)
# Plot the tiles
plot_tiles(nc_osmnolbl)
}
