% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_typical.R
\name{typical}
\alias{typical}
\title{Generate "typical" datasets for use in \code{marginaleffects}'s \code{newdata} argument}
\usage{
typical(..., model = NULL, data = NULL)
}
\arguments{
\item{...}{named arguments with vectors of values for the typical variables
to construct (see Examples below.) The typical data will include
combinations of unique values from these vectors}

\item{model}{Model object}

\item{data}{data.frame (one and only one of the \code{model} and \code{data} arguments
must be true).}
}
\value{
A \code{data.frame} in which each row corresponds to one combination of the named
predictors supplied by the user via the \code{...} dots. Variables which are not
explicitly defined are held at their mean or mode.
}
\description{
Generate "typical" datasets for use in \code{marginaleffects}'s \code{newdata} argument
}
\details{
If \code{typical} is used in a \code{marginaleffects} or \code{predictions} call as the
\code{newdata} argument, users do not need to specify the \code{model} or \code{data}
argument. The data is extracted automatically from the model.

If users supply a model, the data used to fit that model is retrieved using
the \code{insight::get_data} function.
}
\examples{
# The output only has 2 rows, and all the variables except `hp` are at their
# mean or mode.
typical(data = mtcars, hp = c(100, 110))

# We get the same result by feeding a model instead of a data.frame
mod <- lm(mpg ~ hp, mtcars)
typical(model = mod, hp = c(100, 110))

# Use in `marginaleffects` to compute "Typical Marginal Effects"
marginaleffects(mod, newdata = typical(hp = c(100, 110)))
}
