% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vcov.R, R/methods_MCMCglmm.R,
%   R/methods_afex.R, R/methods_aod.R, R/methods_biglm.R, R/methods_brms.R,
%   R/methods_dbarts.R, R/methods_gamlss.R, R/methods_glmmTMB.R,
%   R/methods_inferences_simulation.R, R/methods_mhurdle.R, R/methods_mlr3.R,
%   R/methods_rms.R, R/methods_scam.R, R/methods_tidymodels.R
\name{get_vcov}
\alias{get_vcov}
\alias{get_vcov.default}
\alias{get_vcov.MCMCglmm}
\alias{get_vcov.afex_aov}
\alias{get_vcov.glimML}
\alias{get_vcov.biglm}
\alias{get_vcov.brmsfit}
\alias{get_vcov.bart}
\alias{get_vcov.gamlss}
\alias{get_vcov.glmmTMB}
\alias{get_vcov.inferences_simulation}
\alias{get_vcov.mhurdle}
\alias{get_vcov.Learner}
\alias{get_vcov.orm}
\alias{get_vcov.scam}
\alias{get_vcov.model_fit}
\alias{get_vcov.workflow}
\title{Get a named variance-covariance matrix from a model object (internal function)}
\usage{
get_vcov(model, ...)

\method{get_vcov}{default}(model, vcov = NULL, ...)

\method{get_vcov}{MCMCglmm}(model, vcov = NULL, ...)

\method{get_vcov}{afex_aov}(model, vcov = NULL, ...)

\method{get_vcov}{glimML}(model, vcov = NULL, ...)

\method{get_vcov}{biglm}(model, vcov = NULL, ...)

\method{get_vcov}{brmsfit}(model, vcov = NULL, ...)

\method{get_vcov}{bart}(model, vcov = NULL, ...)

\method{get_vcov}{gamlss}(model, ...)

\method{get_vcov}{glmmTMB}(model, ...)

\method{get_vcov}{inferences_simulation}(model, ...)

\method{get_vcov}{mhurdle}(model, vcov = NULL, ...)

\method{get_vcov}{Learner}(model, ...)

\method{get_vcov}{orm}(model, vcov = NULL, ...)

\method{get_vcov}{scam}(model, vcov = NULL, ...)

\method{get_vcov}{model_fit}(model, type = NULL, ...)

\method{get_vcov}{workflow}(model, type = NULL, ...)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default.}
}
\value{
A named square matrix of variance and covariances. The names must match the coefficient names.
}
\description{
Get a named variance-covariance matrix from a model object (internal function)
}
\keyword{internal}
