% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.predictions}
\alias{tidy.predictions}
\title{Tidy a \code{predictions} object}
\usage{
\method{tidy}{predictions}(x, ...)
}
\arguments{
\item{x}{An object produced by the \code{predictions} function.}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A "tidy" \code{data.frame} of summary statistics which conforms to the
\code{broom} package specification.
}
\description{
Calculate average adjusted predictions by taking the mean of all the
unit-level adjusted predictions computed by the \code{predictions} function.
}
\examples{
mod <- lm(mpg ~ hp * wt + factor(gear), data = mtcars)
mfx <- predictions(mod)
tidy(mfx)
}
