% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.marginaleffects}
\alias{tidy.marginaleffects}
\title{Tidy a \code{marginaleffects} object}
\usage{
\method{tidy}{marginaleffects}(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An object produced by the \code{marginaleffects} function.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int=TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{The "Model-Specific Arguments" section below gives a list of arguments which can modify the behavior of this function for certain models (e.g., mixed-effects or bayesian).}
}
\value{
A "tidy" \code{data.frame} of summary statistics which conforms to the
\code{broom} package specification.
}
\description{
Tidy a \code{marginaleffects} object
}
\details{
The \code{tidy} function calculates average marginal effects by taking the mean
of all the unit-level marginal effects computed by the \code{marginaleffects}
function.
}
\examples{
mod <- lm(mpg ~ hp * wt + factor(gear), data = mtcars)
mfx <- marginaleffects(mod)
tidy(mfx)
}
