% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R, R/persp.R
\name{image.lm}
\alias{image.lm}
\alias{image.glm}
\alias{image.loess}
\alias{persp.lm}
\alias{persp.glm}
\alias{persp.loess}
\title{Perspective and heatmap/contour plots for models}
\usage{
\method{image}{lm}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, nz = 20, xlab = xvar,
  ylab = yvar, xaxs = "i", yaxs = xaxs, bty = "o",
  col = gray(seq(0.05, 0.95, length.out = nz), alpha = 0.75),
  contour = TRUE, contour.labels = NULL, contour.drawlabels = TRUE,
  contour.cex = 0.6, contour.col = "black", contour.lty = 1,
  contour.lwd = 1, ...)

\method{image}{glm}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, nz = 20, xlab = xvar,
  ylab = yvar, xaxs = "i", yaxs = xaxs, bty = "o",
  col = gray(seq(0.05, 0.95, length.out = nz), alpha = 0.75),
  contour = TRUE, contour.labels = NULL, contour.drawlabels = TRUE,
  contour.cex = 0.6, contour.col = "black", contour.lty = 1,
  contour.lwd = 1, ...)

\method{image}{loess}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, nz = 20, xlab = xvar,
  ylab = yvar, xaxs = "i", yaxs = xaxs, bty = "o",
  col = gray(seq(0.05, 0.95, length.out = nz), alpha = 0.75),
  contour = TRUE, contour.labels = NULL, contour.drawlabels = TRUE,
  contour.cex = 0.6, contour.col = "black", contour.lty = 1,
  contour.lwd = 1, ...)

\method{persp}{lm}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, theta = 45, phi = 10,
  shade = 0.75, xlab = xvar, ylab = yvar, zlab = if (match.arg(what) ==
  "prediction") "Predicted value" else paste0("Marginal effect of ", dx),
  ticktype = c("detailed", "simple"), ...)

\method{persp}{glm}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, theta = 45, phi = 10,
  shade = 0.75, xlab = xvar, ylab = yvar, zlab = if (match.arg(what) ==
  "prediction") "Predicted value" else paste0("Marginal effect of ", dx),
  ticktype = c("detailed", "simple"), ...)

\method{persp}{loess}(x, xvar = attributes(terms(x))[["term.labels"]][1],
  yvar = attributes(terms(x))[["term.labels"]][2], dx = xvar,
  what = c("prediction", "effect"), type = c("response", "link"),
  vcov = stats::vcov(x), nx = 25L, ny = nx, theta = 45, phi = 10,
  shade = 0.75, xlab = xvar, ylab = yvar, zlab = if (match.arg(what) ==
  "prediction") "Predicted value" else paste0("Marginal effect of ", dx),
  ticktype = c("detailed", "simple"), ...)
}
\arguments{
\item{x}{A model object.}

\item{xvar}{A character string specifying the name of variable to use as the \samp{x} dimension in the plot. See \code{\link[graphics]{persp}} for details.}

\item{yvar}{A character string specifying the name of variable to use as the \samp{y} dimension in the plot. See \code{\link[graphics]{persp}} for details.}

\item{dx}{A character string specifying the name of the variable for which the conditional average marginal effect is desired when \code{what = "effect"}. By default this is \code{xvar}.}

\item{what}{A character string specifying whether to draw \dQuote{prediction} (fitted values from the model, calculated using \code{\link[stats]{predict}}) or \dQuote{effect} (marginal effect of \code{dx}, using \code{\link{margins}}).}

\item{type}{A character string specifying whether to calculate predictions on the response scale (default) or link (only relevant for non-linear models).}

\item{vcov}{A matrix containing the variance-covariance matrix for estimated model coefficients, or a function to perform the estimation with \code{model} as its only argument.}

\item{nx}{An integer specifying the number of points across \code{x} at which to calculate the predicted value or marginal effect.}

\item{ny}{An integer specifying the number of points across \code{y} at which to calculate the predicted value or marginal effect.}

\item{nz}{An integer specifying, for \code{image}, the number of breakpoints to use when coloring the plot.}

\item{xlab}{A character string specifying the value of \code{xlab} in \code{\link[graphics]{persp}} or \code{\link[graphics]{image}}.}

\item{ylab}{A character string specifying the value of \code{ylab} in \code{\link[graphics]{persp}} or \code{\link[graphics]{image}}.}

\item{xaxs}{A character string specifying the x-axis type (see \code{\link[graphics]{par}}).}

\item{yaxs}{A character string specifying the y-axis type (see \code{\link[graphics]{par}}).}

\item{bty}{A character string specifying the box type (see \code{\link[graphics]{par}}).}

\item{col}{A character vector specifying colors to use when coloring the contour plot.}

\item{contour}{For \code{image}, a logical specifying whether to overlay contour lines onto the heatmap using \code{\link[graphics]{contour}}.}

\item{contour.labels}{For \code{image}, if \code{contour = TRUE} a logical specifying whether to overlay contour lines onto the heatmap.}

\item{contour.drawlabels}{For \code{image}, if \code{contour = TRUE} a logical specifying whether to overlay contour lines onto the heatmap.}

\item{contour.cex}{For \code{image}, if \code{contour = TRUE} and \code{contour.drawlabels = TRUE} a numeric specifying the label size for contour line labels (see \code{\link[graphics]{par}}).}

\item{contour.col}{For \code{image}, if \code{contour = TRUE} a character string specifying a color for contour lines.}

\item{contour.lty}{For \code{image}, if \code{contour = TRUE} an integer specifying a line type for contour lines (see \code{\link[graphics]{par}}).}

\item{contour.lwd}{For \code{image}, if \code{contour = TRUE} an integer specifying a line width for contour lines (see \code{\link[graphics]{par}}).}

\item{\dots}{Additional arguments passed to \code{\link[graphics]{persp}} or \code{\link[graphics]{image}}.}

\item{theta}{For \code{persp}, an integer vector specifying the value of \code{theta} in \code{\link[graphics]{persp}}. If length greater than 1, multiple subplots are drawn with different rotations.}

\item{phi}{For \code{persp}, an integer vector specifying the value of \code{phi} in \code{\link[graphics]{persp}}. If length greater than 1, multiple subplots are drawn with different rotations.}

\item{shade}{For \code{persp}, an integer vector specifying the value of \code{shade} in \code{\link[graphics]{persp}}.}

\item{zlab}{A character string specifying the value of \code{zlab} (vertical axis label) in \code{\link[graphics]{persp}}.}

\item{ticktype}{A character string specifying one of: \dQuote{detailed} (the default) or \dQuote{simple}. See \code{\link[graphics]{persp}}.}
}
\description{
Draw one or more perspectives plots reflecting predictions or marginal effects from a model, or the same using a flat heatmap or \dQuote{filled contour} (\code{\link[graphics]{image}}) representation. Currently methods exist for \dQuote{lm}, \dQuote{glm}, and \dQuote{loess} models.
}
\examples{
\dontrun{
  require('datasets')
  # prediction from several angles
  m <- lm(mpg ~ wt*drat, data = mtcars)
  persp(m, theta = c(45, 135, 225, 315))

  # flat/heatmap representation
  image(m)

  # marginal effect of 'drat' across drat and wt
  m <- lm(mpg ~ wt*drat*I(drat^2), data = mtcars)
  persp(m, xvar = "drat", yvar = "wt", what = "effect", 
        nx = 10, ny = 10, ticktype = "detailed")

  # a non-linear model
  m <- glm(am ~ wt*drat, data = mtcars, family = binomial)
  persp(m, theta = c(30, 60)) # prediction
  # flat/heatmap representation
  image(m)

  # effects on linear predictor and outcome
  persp(m, xvar = "drat", yvar = "wt", what = "effect", type = "link")
  persp(m, xvar = "drat", yvar = "wt", what = "effect", type = "response")
}

}
\seealso{
\code{\link{plot.margins}}, \code{\link{cplot}}
}
\keyword{graphics}
\keyword{hplot}
