% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{get_background}
\alias{get_background}
\title{Get background data}
\usage{
get_background(type)
}
\arguments{
\item{type}{character. Either \code{"random"} or \code{"targetgroup"}.}
}
\value{
A dataframe with all background points.
}
\description{
\code{get_background} returns pre-generated background data.
}
\details{
The targetgroup background was created by subsampling an average of
  37 occurrence records (20000 in total) from each species in the dataset
  providing in essence the same sampling bias as the entire dataset.
}
\examples{
\dontrun{
random_bg <- get_background("random")
plot(random_bg[,2:3], pch=".", main="random background")

targetgroup_bg <- get_background("targetgroup")
plot(targetgroup_bg[,2:3], pch=".", main="targetgroup background")
}
}
\seealso{
\code{\link{get_fold_data}} \code{\link{get_occurrences}}
  \code{\link{get_folds}}
}

