% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo-id.R
\name{pseudo_id}
\alias{pseudo_id}
\alias{pseudo_id.pseudo_id}
\alias{pseudo_id.default}
\alias{pseudo_id.factor}
\title{Create an ID for a vector}
\usage{
pseudo_id(x)

\method{pseudo_id}{pseudo_id}(x)

\method{pseudo_id}{default}(x)

\method{pseudo_id}{factor}(x)
}
\arguments{
\item{x}{A vector of values}
}
\value{
A \code{pseudo_id} object where the \code{integer} value of the vector
correspond to the position of the unique values in the attribute \code{"uniques"}.
}
\description{
Transforms a vector into an integer of IDs.
}
\examples{
set.seed(42)
(x <- sample(letters, 10, TRUE))
(pid <- pseudo_id(x))
attr(pid, "uniques")[pid]

}
