% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_base.R, R/system_basic.R,
%   R/system_deterministic_adjustment.R, R/system_directional.R,
%   R/system_equilibrium.R, R/system_stochastic_adjustment.R
\docType{class}
\name{system_classes}
\alias{system_classes}
\alias{system_base-class}
\alias{system_basic-class}
\alias{system_deterministic_adjustment-class}
\alias{system_directional-class}
\alias{system_equilibrium-class}
\alias{system_stochastic_adjustment-class}
\title{System classes}
\description{
System classes
}
\details{
Classes with data and functionality describing systems of models.
}
\section{Functions}{
\itemize{
\item \code{system_base-class}: System base class

\item \code{system_basic-class}: Basic model's system class

\item \code{system_deterministic_adjustment-class}: Deterministic adjustment model's system class

\item \code{system_directional-class}: Directional system class

\item \code{system_equilibrium-class}: Equilibrium model's system class

\item \code{system_stochastic_adjustment-class}: Stochastic adjustment model's system class
}}

\section{Slots}{

\describe{
\item{\code{demand}}{Demand equation.}

\item{\code{supply}}{Supply equation.}

\item{\code{correlated_shocks}}{Boolean indicating whether the shock of the
equations of the system are correlated.}

\item{\code{sample_separation}}{Boolean indicating whether the sample of the
system is separated.}

\item{\code{quantity_vector}}{A vector with the system's observed quantities.}

\item{\code{price_vector}}{A vector with the system's observed prices.}

\item{\code{rho}}{Correlation coefficient of demand and supply shocks.}

\item{\code{rho1}}{\deqn{\rho_{1} = \frac{1}{\sqrt{1 - \rho}}}}

\item{\code{rho2}}{\deqn{\rho_{2} = \rho\rho_{1}}}

\item{\code{lh}}{Likelihood values for each observation.}

\item{\code{gamma}}{Excess demand coefficient.}

\item{\code{delta}}{\deqn{\delta = \gamma + \alpha_{d} - \alpha_{s}}}

\item{\code{mu_P}}{\deqn{\mu_{P} = \mathrm{E}P}}

\item{\code{var_P}}{\deqn{V_{P} = \mathrm{Var}P}}

\item{\code{sigma_P}}{\deqn{\sigma_{P} = \sqrt{V_{P}}}}

\item{\code{h_P}}{\deqn{h_{P} = \frac{P - \mu_{P}}{\sigma_{P}}}}

\item{\code{lagged_price_vector}}{A vector with the system's observed prices lagged by
one date.}

\item{\code{mu_Q}}{\deqn{\mu_{Q} = \mathrm{E}Q}}

\item{\code{var_Q}}{\deqn{V_{Q} = \mathrm{Var}Q}}

\item{\code{sigma_Q}}{\deqn{\sigma_{Q} = \sqrt{V_{Q}}}}

\item{\code{h_Q}}{\deqn{h_{Q} = \frac{Q - \mu_{Q}}{\sigma_{Q}}}}

\item{\code{rho_QP}}{\deqn{\rho_{QP} =
\frac{\mathrm{Cov}(Q,P)}{\sqrt{\mathrm{Var}Q\mathrm{Var}P}}}}

\item{\code{rho_1QP}}{\deqn{\rho_{1,QP} = \frac{1}{\sqrt{1 - \rho_{QP}^2}}}}

\item{\code{rho_2QP}}{\deqn{\rho_{2,QP} = \rho_{QP}\rho_{1,QP}}}

\item{\code{z_QP}}{\deqn{z_{QP} = \frac{h_{Q} - \rho_{QP}h_{P}}{\sqrt{1 - \rho_{QP}^2}}}}

\item{\code{z_PQ}}{\deqn{z_{PQ} = \frac{h_{P} - \rho_{PQ}h_{Q}}{\sqrt{1 - \rho_{PQ}^2}}}}

\item{\code{price_equation}}{Price equation.}

\item{\code{zeta}}{\deqn{\zeta = \sqrt{1 - \rho_{DS}^2 - \rho_{DP}^2 - \rho_{SP}^2 +
2 \rho_DP \rho_DS \rho_SP}}}

\item{\code{zeta_DD}}{\deqn{\zeta_{DD} = 1 - \rho_{SP}^2}}

\item{\code{zeta_DS}}{\deqn{\zeta_{DS} = \rho_{DS} - \rho_{DP}\rho_{SP}}}

\item{\code{zeta_DP}}{\deqn{\zeta_{DP} = \rho_{DP} - \rho_{DS}\rho_{SP}}}

\item{\code{zeta_SS}}{\deqn{\zeta_{SS} = 1 - \rho_{DP}^2}}

\item{\code{zeta_SP}}{\deqn{\zeta_{SP} = \rho_{SP} - \rho_{DS}\rho_{DP}}}

\item{\code{zeta_PP}}{\deqn{\zeta_{PP} = 1 - \rho_{DS}^2}}

\item{\code{mu_D}}{\deqn{\mu_{D} = \mathrm{E}D}}

\item{\code{var_D}}{\deqn{V_{D} = \mathrm{Var}D}}

\item{\code{sigma_D}}{\deqn{\sigma_{D} = \sqrt{V_{D}}}}

\item{\code{mu_S}}{\deqn{\mu_{S} = \mathrm{E}S}}

\item{\code{var_S}}{\deqn{V_{S} = \mathrm{Var}S}}

\item{\code{sigma_S}}{\deqn{\sigma_{S} = \sqrt{V_{S}}}}

\item{\code{sigma_DP}}{\deqn{\sigma_{DP} = \mathrm{Cov}(D, P)}}

\item{\code{sigma_DS}}{\deqn{\sigma_{DS} = \mathrm{Cov}(D, S)}}

\item{\code{sigma_SP}}{\deqn{\sigma_{SP} = \mathrm{Cov}(S, P)}}

\item{\code{rho_DS}}{\deqn{\rho_{DS} =
\frac{\mathrm{Cov}(D,S)}{\sqrt{\mathrm{Var}D\mathrm{Var}S}}}}

\item{\code{rho_DP}}{\deqn{\rho_{DP} =
\frac{\mathrm{Cov}(D,P)}{\sqrt{\mathrm{Var}D\mathrm{Var}P}}}}

\item{\code{rho_SP}}{\deqn{\rho_{SP} =
\frac{\mathrm{Cov}(S,P)}{\sqrt{\mathrm{Var}S\mathrm{Var}P}}}}

\item{\code{h_D}}{\deqn{h_{D} = \frac{D - \mu_{D}}{\sigma_{D}}}}

\item{\code{h_S}}{\deqn{h_{S} = \frac{S - \mu_{S}}{\sigma_{S}}}}

\item{\code{z_DP}}{\deqn{z_{DP} = \frac{h_{D} - \rho_{DP}h_{P}}{\sqrt{1 - \rho_{DP}^2}}}}

\item{\code{z_PD}}{\deqn{z_{PD} = \frac{h_{P} - \rho_{PD}h_{D}}{\sqrt{1 - \rho_{PD}^2}}}}

\item{\code{z_SP}}{\deqn{z_{SP} = \frac{h_{S} - \rho_{SP}h_{P}}{\sqrt{1 - \rho_{SP}^2}}}}

\item{\code{z_PS}}{\deqn{z_{PS} = \frac{h_{P} - \rho_{PS}h_{S}}{\sqrt{1 - \rho_{PS}^2}}}}

\item{\code{omega_D}}{\deqn{\omega_{D} = \frac{h_{D}\zeta_{DD} - h_{S}\zeta_{DS} -
h_{P}\zeta_{DP}}{\zeta_{DD}}}}

\item{\code{omega_S}}{\deqn{\omega_{S} = \frac{h_{S}\zeta_{SS} - h_{S}\zeta_{SS} -
h_{P}\zeta_{SP}}{\zeta_{SS}}}}

\item{\code{w_D}}{\deqn{w_{D} = - \frac{h_{D}^2 - 2 h_{D} h_{P} \rho_{DP} +
h_{P}^2}{2\zeta_{SS}}}}

\item{\code{w_S}}{\deqn{w_{S} = - \frac{h_{S}^2 - 2 h_{S} h_{P} \rho_{SP} +
h_{P}^2}{2\zeta_{DD}}}}

\item{\code{psi_D}}{\deqn{\psi_{D} = \phi\left(\frac{\omega_{D}}{\zeta}\right)}}

\item{\code{psi_S}}{\deqn{\psi_{S} = \phi\left(\frac{\omega_{S}}{\zeta}\right)}}

\item{\code{Psi_D}}{\deqn{\Psi_{D} = 1 - \Phi\left(\frac{\omega_{D}}{\zeta}\right)}}

\item{\code{Psi_S}}{\deqn{\Psi_{S} = 1 - \Phi\left(\frac{\omega_{S}}{\zeta}\right)}}

\item{\code{g_D}}{\deqn{g_{D} = \frac{\psi_{D}}{\Psi_{D}}}}

\item{\code{g_S}}{\deqn{g_{S} = \frac{\psi_{S}}{\Psi_{S}}}}

\item{\code{rho_ds}}{Shadows \code{rho} in the \linkS4class{diseq_stochastic_adjustment} model}

\item{\code{rho_dp}}{Correlation of demand and price equations' shocks.}

\item{\code{rho_sp}}{Correlation of supply and price equations' shocks.}

\item{\code{L_D}}{Likelihood conditional on excess supply.}

\item{\code{L_S}}{Likelihood conditional on excess demand.}
}}

