% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowerT.R
\name{lowerT}
\alias{lowerT}
\title{An utility function to calculate upper limit of T statistic}
\usage{
lowerT(low, hat, sigmasq, Tstar, weights, B, alpha)
}
\arguments{
\item{low}{lower limit}

\item{hat}{estimates}

\item{sigmasq}{variance}

\item{Tstar}{T statistics estimated from bootstrap samples}

\item{weights}{model weights}

\item{B}{number of bootstraps}

\item{alpha}{confidence level}
}
\value{
returns upper limit of T-statistic
}
\description{
An utility function to calculate upper limit of T statistic
}
\examples{
# set some parameters
low <- 100 # lower bound
hat <- rep(150, 6) # estimates obtained from each model
sigmasq <- 10 # variance
Tstar <- matrix(rep(100,600),6,100) # T statistics estimated from bootstrap samples
weights <- rep(1/6, 6) # model weights
B <- 100 # number of bootstrapped samples
alpha <- 0.05 # confidence level

# calculate the upper limit of T statistics
res <- marp::lowerT(low, hat, sigmasq, Tstar, weights, B, alpha)

# print result
cat("res = ", res, "\n")

}
