% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregTree.R
\name{gregTree}
\alias{gregTree}
\title{Compute a regression tree estimator}
\usage{
gregTree(
  y,
  xsample,
  xpop,
  pi = NULL,
  pi2 = NULL,
  var_est = FALSE,
  var_method = "LinHB",
  B = 1000,
  pval = 0.05,
  perm_reps = 500,
  bin_size = NULL,
  fpc = T,
  messages = T
)
}
\arguments{
\item{y}{A numeric vector of the sampled response variable.}

\item{xsample}{A data frame of the auxiliary data in the sample.}

\item{xpop}{A data frame of population level auxiliary information.  It must contain the same names as xsample.  If datatype = "raw", must contain unit level data.  If datatype = "totals" or "means", then contains one row of aggregated, population totals or means for the auxiliary data. Default is "raw".}

\item{pi}{A numeric vector of inclusion probabilities for each sampled unit in y.  If NULL, then simple random sampling without replacement is assumed.}

\item{pi2}{A square matrix of the joint inclusion probabilities.  Needed for the "LinHT" variance estimator.}

\item{var_est}{A logical indicating whether or not to compute a variance estimator.  Default is FALSE.}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "LinHB"= Hajek-Berger estimator, "LinHH" = Hansen-Hurwitz estimator, "LinHTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "LinHT" = Horvitz-Thompson estimator or a resampling technique: "bootstrapSRS" = bootstrap variance estimator under simple random sampling without replacement. The default is "LinHB".}

\item{B}{The number of bootstrap samples if computing the bootstrap variance estimator.  Default is 1000.}

\item{pval}{Designated p-value level to reject null hypothesis in permutation test used to fit the regression tree. Default value is 0.05.}

\item{perm_reps}{An integer specifying the number of permutations for each permutation test run to fit the regression tree. Default value is 500.}

\item{bin_size}{A integer specifying the minimum number of observations in each node.}

\item{fpc}{Default to TRUE, logical for whether or not the variance calculation should include a finite population correction when calculating the "LinHTSRS" or the "SRSbootstrap" variance estimator.}

\item{messages}{A logical indicating whether to output the messages internal to mase. Default is TRUE.}
}
\value{
A list of output containing:
\itemize{
\item{pop_total:}{Estimate of population total}
\item{pop_mean:}{Estimate of the population mean (or proportion)}
\item{weights:}{Survey weights produced by gregTree}
\item{pop_total_var:}{Estimated variance of population total estimate}
\item{pop_mean_var:}{Estimated variance of population mean estimate}
}
}
\description{
Calculates a regression tree estimator for a finite population mean/proportion or total based on sample data collected from a complex sampling design and auxiliary population data.
}
\examples{
library(dplyr)
data(IdahoPop)
data(IdahoSamp)

xsample <- filter(IdahoSamp, COUNTYFIPS == "16055") 
xpop <- filter(IdahoSamp, COUNTYFIPS == "16055")

gregTree(y = xsample$BA_TPA_ADJ,
         xsample = xsample[c("tcc", "elev")],
         xpop = xpop[c("tcc", "elev")],
         var_est = TRUE)

}
\references{
\insertRef{mcc17b}{mase}
}
