/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.objective;

import choco.cp.solver.search.integer.objective.IntObjectiveManager;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MinIntObjManager
extends IntObjectiveManager {
    public MinIntObjManager(IntDomainVar objective) {
        super(objective);
    }

    @Override
    public int getInitialBoundValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getFloorValue() {
        return this.objective.getInf();
    }

    @Override
    public int getCeilValue() {
        return this.objective.getSup();
    }

    @Override
    public void postTargetBound() throws ContradictionException {
        this.objective.setSup(this.targetBound);
    }

    @Override
    public void incrementFloorBound() {
        ++this.floorBound;
    }

    @Override
    public void postFloorBound() throws ContradictionException {
        this.objective.setInf(this.floorBound);
    }

    @Override
    public void setBound() {
        int v = this.getFloorValue();
        if (v < this.bound) {
            this.bound = v;
        }
    }

    @Override
    public void setTargetBound() {
        this.targetBound = this.getCeilValue() - 1;
    }

    @Override
    public boolean isTargetInfeasible() {
        return this.targetBound < this.floorBound;
    }
}

