/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.delta;

import choco.cp.solver.variables.delta.iterators.IntervalIntIterator;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.variables.delta.IDeltaDomain;

public final class IntervalDeltaDomain
implements IDeltaDomain {
    private int lastInfPropagated;
    private int lastSupPropagated;
    private int currentInfPropagated;
    private int currentSupPropagated;
    private final AbstractIntDomain domain;
    private IntervalIntIterator _iterator;

    public IntervalDeltaDomain(AbstractIntDomain domain, int lastInfPropagated, int lastSupPropagated) {
        this.domain = domain;
        this.lastInfPropagated = lastInfPropagated;
        this.lastSupPropagated = lastSupPropagated;
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
    }

    @Override
    public void freeze() {
        this.currentInfPropagated = this.domain.getInf();
        this.currentSupPropagated = this.domain.getSup();
    }

    @Override
    public void remove(int value) {
        if (this.lastInfPropagated == Integer.MIN_VALUE) {
            this.lastInfPropagated = this.domain.getInf();
            this.lastSupPropagated = this.domain.getSup();
        }
    }

    @Override
    public void clear() {
        this.lastInfPropagated = Integer.MIN_VALUE;
        this.lastSupPropagated = Integer.MAX_VALUE;
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
    }

    @Override
    public boolean isReleased() {
        return this.currentInfPropagated == Integer.MIN_VALUE && this.currentSupPropagated == Integer.MAX_VALUE;
    }

    @Override
    public boolean release() {
        boolean noNewUpdate;
        boolean bl = noNewUpdate = this.domain.getInf() == this.currentInfPropagated && this.domain.getSup() == this.currentSupPropagated;
        if (noNewUpdate) {
            this.lastInfPropagated = Integer.MIN_VALUE;
            this.lastSupPropagated = Integer.MAX_VALUE;
        } else {
            this.lastInfPropagated = this.currentInfPropagated;
            this.lastSupPropagated = this.currentSupPropagated;
        }
        this.currentInfPropagated = Integer.MIN_VALUE;
        this.currentSupPropagated = Integer.MAX_VALUE;
        return noNewUpdate;
    }

    @Override
    public String pretty() {
        return this.lastInfPropagated + "->" + this.lastSupPropagated;
    }

    @Override
    public DisposableIntIterator iterator() {
        if (this._iterator == null) {
            this._iterator = new IntervalIntIterator();
        } else if (!this._iterator.reusable()) {
            assert (false);
            this._iterator = new IntervalIntIterator();
        }
        this._iterator.init(this.currentInfPropagated, this.currentSupPropagated, this.lastInfPropagated, this.lastSupPropagated);
        return this._iterator;
    }

    @Override
    public IDeltaDomain copy() {
        IntervalDeltaDomain delta = new IntervalDeltaDomain(this.domain, this.lastInfPropagated, this.lastSupPropagated);
        delta.currentInfPropagated = this.currentInfPropagated;
        delta.currentSupPropagated = this.currentSupPropagated;
        return delta;
    }
}

