% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/toptradingcycle.R
\name{toptrading}
\alias{toptrading}
\title{Compute the top trading cycle algorithm}
\usage{
toptrading(pref = NULL, utils = NULL)
}
\arguments{
\item{pref}{An nxn matrix, each column representing each agent's ordinal preferences
over other agents. E.g., if the jth row of the ith column is 4, then agent i ranks
agent 4 jth.}

\item{utils}{An nxn matrix, each column representing each agent's cardinal preferences
over other agents. E.g., if the jth row of the ith column is 2.3, then agent i gets
utility of 2.3 from being matched to agent j.}
}
\value{
A vector of length n corresponding to the matchings being made, so that
e.g. if the 4th element is 6 then agent 4 was matched to agent 6. This vector
uses R style indexing.
}
\description{
Compute the top trading cycle algorithm
}
\examples{
results = toptrading(utils = replicate(4, rnorm(4)))
}

