% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_wrapper_ttc}
\alias{cpp_wrapper_ttc}
\title{Computes the top trading cycle algorithm}
\usage{
cpp_wrapper_ttc(pref)
}
\arguments{
\item{pref}{is a matrix with the preference order of all individuals in the
market. If there are \code{n} individuals, then this matrix will be of
dimension \code{n} by \code{n}. The \code{i,j}th element refers to
\code{j}'s \code{i}th most favorite partner. Preference orders must be
specified using C++ indexing (starting at 0).}
}
\value{
A vector of length \code{n} corresponding to the matchings being
  made, so that e.g. if the \code{4}th element is \code{5} then agent
  \code{4} was matched to agent \code{6}. This vector uses C++ indexing that
  starts at 0.
}
\description{
This is the C++ wrapper for the top trading cycle algorithm. Users should not
call this function directly, but instead use
\code{\link{toptrading}}.
}
\details{
This function uses the top trading cycle algorithm to find a stable trade
between agents, each with some indivisible good, and with preferences over
the goods of other agents. Each agent is matched to one other agent, and
matchings are not necessarily two-way. Agents may be matched with
themselves.
}

