# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' C++ wrapper for Gale-Shapley Algorithm
#'
#' This function provides an R wrapper for the C++ backend. Users should not
#' call this function directly and instead use
#' \code{\link{galeShapley.marriageMarket}} or
#' \code{\link{galeShapley.collegeAdmissions}}.
#'
#' @param proposerPref is a matrix with the preference order of the proposing
#'   side of the market. If there are \code{n} proposers and \code{m} reviewers
#'   in the market, then this matrix will be of dimension \code{m} by \code{n}.
#'   The \code{i,j}th element refers to \code{j}'s \code{i}th most favorite
#'   partner. Preference orders must be complete and specified using C++
#'   indexing (starting at 0).
#' @param reviewerUtils is a matrix with cardinal utilities of the courted side
#'   of the market. If there are \code{n} proposers and \code{m} reviewers, then
#'   this matrix will be of dimension \code{n} by \code{m}. The \code{i,j}th
#'   element refers to the payoff that individual \code{j} receives from being
#'   matched to individual \code{i}.
#'  @return  A list with elements that specify who is matched to whom. Suppose
#'    there are \code{n} proposers and \code{m} reviewers. The list contains
#'    the following items:
#'   \itemize{
#'    \item{\code{proposals} is a vector of length \code{n} whose \code{i}th
#'    element contains the number of the reviewer that proposer \code{i} is
#'    matched to using C++ indexing. Proposers that remain unmatched will be
#'    listed as being matched to \code{m}.}
#'    \item{\code{engagements} is a vector of length \code{m} whose \code{j}th
#'    element contains the number of the proposer that reviewer \code{j} is
#'    matched to using C++ indexing. Reviwers that remain unmatched will be
#'    listed as being matched to \code{n}.}
#'   }
cpp_wrapper_galeshapley <- function(proposerPref, reviewerUtils) {
    .Call('matchingR_cpp_wrapper_galeshapley', PACKAGE = 'matchingR', proposerPref, reviewerUtils)
}

#' C++ Wrapper to Check Stability of Two-sided Matching
#'
#' This function checks if a given matching is stable for a particular set of
#' preferences. This function provides an R wrapper for the C++ backend. Users
#' should not call this function directly and instead use
#' \code{\link{galeShapley.checkStability}}.
#'
#' @param proposerUtils is a matrix with cardinal utilities of the proposing
#'   side of the market. If there are \code{n} proposers and \code{m} reviewers,
#'   then this matrix will be of dimension \code{m} by \code{n}. The
#'   \code{i,j}th element refers to the payoff that individual \code{j} receives
#'   from being matched to individual \code{i}.
#' @param reviewerUtils is a matrix with cardinal utilities of the courted side
#'   of the market. If there are \code{n} proposers and \code{m} reviewers, then
#'   this matrix will be of dimension \code{n} by \code{m}. The \code{i,j}th
#'   element refers to the payoff that individual \code{j} receives from being
#'   matched to individual \code{i}.
#' @param proposals is a matrix that contains the number of the reviewer that a
#'   given proposer is matched to: the first row contains the number of the
#'   reviewer that is matched with the first proposer (using C++ indexing), the
#'   second row contains the id of the reviewer that is matched with the second
#'   proposer, etc. The column dimension accommodates proposers with multiple
#'   slots.
#' @param engagements is a matrix that contains the number of the proposer that
#'   a given reviewer is matched to (using C++ indexing). The column dimension
#'   accommodates reviewers with multiple slots.
#' @return true if the matching is stable, false otherwise
cpp_wrapper_galeshapley_check_stability <- function(proposerUtils, reviewerUtils, proposals, engagements) {
    .Call('matchingR_cpp_wrapper_galeshapley_check_stability', PACKAGE = 'matchingR', proposerUtils, reviewerUtils, proposals, engagements)
}

#' Computes a stable roommate matching
#'
#' This is the C++ wrapper for the stable roommate problem. Users should not
#' call this function directly, but instead use
#' \code{\link{roommate}}.
#' 
#' @param pref is a matrix with the preference order of each individual in the
#'   market. If there are \code{n} individuals, then this matrix will be of
#'   dimension \code{n-1} by \code{n}. The \code{i,j}th element refers to
#'   \code{j}'s \code{i}th most favorite partner. Preference orders must be
#'   specified using C++ indexing (starting at 0). The matrix \code{pref} must
#'   be of dimension \code{n-1} by \code{n}.
#' @return A vector of length \code{n} corresponding to the matchings that were
#'   formed (using C++ indexing). E.g. if the \code{4}th element of this vector
#'   is \code{0} then individual \code{4} was matched with individual \code{1}.
#'   If no stable matching exists, then this function returns a vector of
#'   zeros.
cpp_wrapper_irving <- function(pref) {
    .Call('matchingR_cpp_wrapper_irving', PACKAGE = 'matchingR', pref)
}

#' Check if a matching solves the stable roommate problem
#'
#' This function checks if a given matching is stable for a particular set of
#' preferences. This function checks if there's an unmatched pair that would
#' rather be matched with each other than with their assigned partners.
#'
#' @param pref is a matrix with the preference order of each individual in the
#'   market. If there are \code{n} individuals, then this matrix will be of
#'   dimension \code{n-1} by \code{n}. The \code{i,j}th element refers to
#'   \code{j}'s \code{i}th most favorite partner. Preference orders must be
#'   specified using C++ indexing (starting at 0). The matrix \code{pref} must
#'   be of dimension \code{n-1} by \code{n}.
#' @param matchings is a vector of length \code{n} corresponding to the
#'   matchings that were formed (using C++ indexing). E.g. if the \code{4}th
#'   element of this vector is \code{0} then individual \code{4} was matched
#'   with individual \code{1}. If no stable matching exists, then this function
#'   returns a vector of zeros.
#' @return true if the matching is stable, false otherwise
cpp_wrapper_irving_check_stability <- function(pref, matchings) {
    .Call('matchingR_cpp_wrapper_irving_check_stability', PACKAGE = 'matchingR', pref, matchings)
}

#' Computes the top trading cycle algorithm
#' 
#' This is the C++ wrapper for the top trading cycle algorithm. Users should not
#' call this function directly, but instead use
#' \code{\link{toptrading}}.
#'
#' This function uses the top trading cycle algorithm to find a stable trade
#' between agents, each with some indivisible good, and with preferences over
#' the goods of other agents. Each agent is matched to one other agent, and
#' matchings are not necessarily two-way. Agents may be matched with
#' themselves.
#'
#' @param pref is a matrix with the preference order of all individuals in the
#'   market. If there are \code{n} individuals, then this matrix will be of
#'   dimension \code{n} by \code{n}. The \code{i,j}th element refers to
#'   \code{j}'s \code{i}th most favorite partner. Preference orders must be
#'   specified using C++ indexing (starting at 0).
#' @return A vector of length \code{n} corresponding to the matchings being
#'   made, so that e.g. if the \code{4}th element is \code{5} then agent
#'   \code{4} was matched to agent \code{6}. This vector uses C++ indexing that
#'   starts at 0.
cpp_wrapper_ttc <- function(pref) {
    .Call('matchingR_cpp_wrapper_ttc', PACKAGE = 'matchingR', pref)
}

#' Check if a one-sided matching for the top trading cycle algorithm is stable
#'
#' @param pref is a matrix with the preference order of all individuals in the
#'   market. If there are \code{n} individuals, then this matrix will be of
#'   dimension \code{n} by \code{n}. The \code{i,j}th element refers to
#'   \code{j}'s \code{i}th most favorite partner. Preference orders must be
#'   specified using C++ indexing (starting at 0).
#' @param matchings is a vector of length \code{n} corresponding to the
#'   matchings being made, so that e.g. if the \code{4}th element is \code{5}
#'   then agent \code{4} was matched to agent \code{6}. This vector uses C++
#'   indexing that starts at 0.
#' @return true if the matching is stable, false otherwise
cpp_wrapper_ttc_check_stability <- function(pref, matchings) {
    .Call('matchingR_cpp_wrapper_ttc_check_stability', PACKAGE = 'matchingR', pref, matchings)
}

#' Sort indices of a matrix within a column
#'
#' Within each column of a matrix, this function returns the indices of each
#' element in descending order
#'
#' @param u is the input matrix with cardinal preferences
#' @return a matrix with sorted indices (the agents' ordinal preferences)
sortIndex <- function(u) {
    .Call('matchingR_sortIndex', PACKAGE = 'matchingR', u)
}

#' Ranks elements with column of a matrix, assuming a one-sided market.
#'
#' Returns the rank of each element with each column of a matrix. So, if row 34
#' is the highest number for column 3, then the first row of column 3 will be
#' 34 -- unless it is column 34, in which case it will be 35, to adjust for the
#' fact that this is a single-sided market.
#'
#' @param u A matrix with agents' cardinal preferences. Column i is agent i's
#'   preferences.
#' @return a matrix with the agents' ordinal preferences
sortIndexOneSided <- function(u) {
    .Call('matchingR_sortIndexOneSided', PACKAGE = 'matchingR', u)
}

#' Rank elements within column of a matrix
#'
#' This function returns the rank of each element within each column of a
#' matrix. The highest element receives the highest rank.
#'
#' @param sortedIdx is the input matrix
#' @return a rank matrix
rankIndex <- function(sortedIdx) {
    .Call('matchingR_rankIndex', PACKAGE = 'matchingR', sortedIdx)
}

