% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{methods}
\name{summary,ABCXYZData-method}
\alias{summary,ABCXYZData-method}
\title{Prints the result summary of an ABC/XYZ analysis}
\usage{
\S4method{summary}{ABCXYZData}(object, withMissing = FALSE)
}
\arguments{
\item{object}{Object of class \code{ABCXYZData}.}

\item{withMissing}{Logical indicating whether missing categories will be shown. Default is \code{FALSE}.}
}
\value{
A \code{data.table} with the summarized results.
}
\description{
Summarizes the items count and value sum grouped by the different ABC- or ABC/XYZ-Classes.
}
\examples{
# ABC Analysis
data("Amount")
abcResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date")
summary(abcResult)

# ABC/XYZ Analysis
data("Amount")
abcxyzResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    XY = 0.3, YZ = 0.5)
summary(abcxyzResult)
}
\seealso{
\code{\link{computeABCXYZAnalysis}} \code{\link[=ABCXYZData-class]{ABCXYZData}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
