% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_metrics_signif.R
\name{null_distribution}
\alias{null_distribution}
\title{Compute null distribution for a set of metrics}
\usage{
null_distribution(
  metrics,
  background_type,
  level_identifier,
  metric_name = "average_precision",
  n_iterations = 10000,
  random_seed = 42
)
}
\arguments{
\item{metrics}{Metrics data frame, containing at least the column
\code{"sim_stat_background_n_{background_type}_{level_identifier}"}.}

\item{background_type}{Background type. Either \code{"ref"} or \code{"non_rep"}.}

\item{level_identifier}{Level identifier. Either \code{"i"} (Level 1_0) or \code{"g"} (Level 2_1).}

\item{metric_name}{name of metric. Only \code{"average_precision"} is currently implemented.}

\item{n_iterations}{number of iterations for generating the null distribution}

\item{random_seed}{Random seed (default = 42)}
}
\value{
Nulls data frame
}
\description{
Compute null distribution for a set of metrics
}
