% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_filter.R
\name{sim_filter_some_different_drop_some}
\alias{sim_filter_some_different_drop_some}
\title{Filter a melted similarity matrix to keep pairs with the same
values in specific columns, and other constraints.}
\usage{
sim_filter_some_different_drop_some(
  sim_df,
  row_metadata,
  any_different_cols,
  all_same_cols = NULL,
  all_different_cols = NULL,
  filter_drop_left = NULL,
  filter_drop_right = NULL,
  annotation_cols = NULL,
  sim_cols = c("id1", "id2", "sim")
)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{row_metadata}{data.frame with row metadata.}

\item{any_different_cols}{character vector specifying columns.}

\item{all_same_cols}{optional character vector specifying columns.}

\item{all_different_cols}{optional character vector specifying columns.}

\item{filter_drop_left}{data.frame of metadata specifying which rows to
drop on the left index.}

\item{filter_drop_right}{data.frame of metadata specifying which rows to
drop on the right index.}

\item{annotation_cols}{optional character vector specifying which columns
from \code{metadata} to annotate the left index of the filtered
\code{sim_df} with.}

\item{sim_cols}{optional character string specifying minimal set of columns
for a similarity matrix}
}
\value{
Filtered \code{sim_df} as a data.frame, keeping only pairs that have
\itemize{
\item same values in all columns of \code{all_same_cols},
\item different values in all columns \code{all_different_cols}, and
\item different values in at least one column of \code{any_different_cols},
}

with further filtering using \code{filter_drop_left} and
\code{filter_drop_right}. Rows are annotated based on the first index,
if specified.
}
\description{
\code{sim_filter_some_different_drop_some} filters a melted similarity matrix
to keep pairs with the same values in specific columns, and other
constraints.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), 4, replace = TRUE),
  Metadata_type1 = sample(c("x", "y"), 4, replace = TRUE),
  Metadata_type2 = sample(c("p", "q"), 4, replace = TRUE),
  x = rnorm(4),
  y = x + rnorm(4) / 100,
  z = y + rnorm(4) / 1000
)
annotation_cols <- c("Metadata_group", "Metadata_type")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
sim_df <- matric::sim_annotate(sim_df, row_metadata, annotation_cols)
all_same_cols <- c("Metadata_group")
all_different_cols <- c("Metadata_type1")
any_different_cols <- c("Metadata_type2")
filter_drop_left <-
  tibble::tibble(Metadata_group = "a", Metadata_type1 = "x")
filter_drop_right <-
  tibble::tibble(Metadata_group = "a", Metadata_type1 = "x")
drop_reference <- FALSE
matric::sim_filter_some_different_drop_some(
  sim_df,
  row_metadata,
  any_different_cols,
  all_same_cols,
  all_different_cols,
  filter_drop_left,
  filter_drop_right,
  annotation_cols
)
}
